/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.cxf.testmodels.AsyncService;
import org.mule.module.cxf.testmodels.AsyncServiceWithSoapAction;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

public class ProxyTestCase
extends AbstractServiceAndFlowTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><test xmlns=\"http://foo\"> foo </test></soap:Body></soap:Envelope>";
    String doGoogleSearch = "<urn:doGoogleSearch xmlns:urn=\"urn:GoogleSearch\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">";
    String msgWithComment = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><!-- comment 1 --><soap:Header><!-- comment 2 --></soap:Header><!-- comment 3 --><soap:Body><!-- comment 4 -->" + this.doGoogleSearch + "<!-- this comment breaks it --><key>1</key><!-- comment 5 --><q>a</q><start>0</start><maxResults>1</maxResults><filter>false</filter><restrict>a</restrict><safeSearch>true</safeSearch><lr>a</lr><ie>b</ie><oe>c</oe></urn:doGoogleSearch><!-- comment 6 --></soap:Body><!-- comment 7 --></soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public ProxyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "proxy-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "proxy-conf-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "proxy-conf-flow-httpn.xml"});
    }

    @Test
    public void testServerWithEcho() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/Echo", ProxyTestCase.getTestMuleMessage((Object)this.msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((resString.indexOf("<test xmlns=\"http://foo\"> foo </test>") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testServerClientProxy() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <foo xmlns=\"http://foo\"></foo></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxy", ProxyTestCase.getTestMuleMessage((Object)msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((resString.indexOf("<foo xmlns=\"http://foo\"") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testProxyBodyValidation() throws Exception {
        this.doTestProxyValidation("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyBodyWithValidation");
    }

    @Test
    public void testProxyBodyValidationWithExternalSchema() throws Exception {
        this.doTestProxyValidation("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyBodyWithValidationAndSchemas");
    }

    @Test
    public void testProxyEnvelopeValidation() throws Exception {
        this.doTestProxyValidation("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyEnvelopeWithValidation");
    }

    public void doTestProxyValidation(String url) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send(url, ProxyTestCase.getTestMuleMessage((Object)this.msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((resString.indexOf("Schema validation error on message") != -1 ? 1 : 0) != 0);
        String valid = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <echo xmlns=\"http://www.muleumo.org\">  <echo>test</echo></echo></soap:Body></soap:Envelope>";
        result = client.send(url, ProxyTestCase.getTestMuleMessage((Object)valid), (OperationOptions)HTTP_REQUEST_OPTIONS);
        resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)resString.contains("<echoResponse xmlns=\"http://www.muleumo.org\">"));
    }

    @Test
    public void testServerClientProxyWithWsdl() throws Exception {
        final Latch latch = new Latch();
        ((FunctionalTestComponent)this.getComponent("serverClientProxyWithWsdl")).setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                latch.countDown();
            }
        });
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyWithWsdl", ProxyTestCase.getTestMuleMessage((Object)msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((resString.indexOf("<test xmlns=\"http://foo\"") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testServerClientProxyWithWsdl2() throws Exception {
        final Latch latch = new Latch();
        ((FunctionalTestComponent)this.getComponent("serverClientProxyWithWsdl2")).setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                latch.countDown();
            }
        });
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyWithWsdl2", ProxyTestCase.getTestMuleMessage((Object)msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((resString.indexOf("<test xmlns=\"http://foo\"") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testServerClientProxyWithTransform() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/proxyWithTransform", ProxyTestCase.getTestMuleMessage((Object)msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        System.out.println(resString);
        Assert.assertTrue((resString.indexOf("<transformed xmlns=\"http://foo\">") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testProxyWithDatabinding() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><greetMe xmlns=\"http://apache.org/hello_world_soap_http/types\"><requestType>Dan</requestType></greetMe></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/greeter-databinding-proxy", ProxyTestCase.getTestMuleMessage((Object)msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((resString.indexOf("greetMeResponse") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testProxyWithFault() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><invalid xmlns=\"http://apache.org/hello_world_soap_http/types\"><requestType>Dan</requestType></invalid></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/greeter-proxy", ProxyTestCase.getTestMuleMessage((Object)msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertFalse((String)"Status code should not be 'OK' when the proxied endpoint returns a fault", (boolean)String.valueOf(200).equals(result.getOutboundProperty("http.status")));
        Assert.assertTrue((resString.indexOf("Fault") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testProxyWithIntermediateTransform() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><greetMe xmlns=\"http://apache.org/hello_world_soap_http/types\"><requestType>Dan</requestType></greetMe></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/transform-proxy", ProxyTestCase.getTestMuleMessage((Object)msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((resString.indexOf("greetMeResponse") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testServerNoSoapAction() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        String path = "/services/routeBasedOnNoSoapAction";
        String expectedString = "<test xmlns=\"http://foo\"";
        MuleMessage result = this.executeSoapCall(msg, "", path);
        this.assertResultContains(result, expectedString);
        result = this.executeSoapCall(msg, null, path);
        this.assertResultContains(result, expectedString);
    }

    @Test
    public void testServerNoSoapActionSpoofing() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        MuleMessage result = this.executeSoapCall(msg, "echo", "/services/routeBasedOnNoSoapAction");
        this.assertResultIsFault(result);
    }

    @Test
    public void testServerSoapAction() throws Exception {
        String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter1>hello world</new:parameter1>  </soapenv:Body></soapenv:Envelope>";
        MuleMessage result = this.executeSoapCall(msg, "EchoOperation1", "/services/routeBasedOnSoapAction");
        this.assertResultContains(result, "<new:parameter1");
    }

    @Test
    public void testServerSoapActionSpoofing() throws Exception {
        String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter1>hello world</new:parameter1>  </soapenv:Body></soapenv:Envelope>";
        MuleMessage result = this.executeSoapCall(msg, "NonSpecifiedOperation", "/services/routeBasedOnSoapAction");
        this.assertResultIsFault(result);
    }

    @Test
    public void testServerNoSoapActionNoWsdl() throws Exception {
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <test xmlns=\"http://foo\"></test></soap:Body></soap:Envelope>";
        String path = "/services/routeBasedOnNoSoapActionNoWsdl";
        String expectedString = "<test xmlns=\"http://foo\"";
        MuleMessage result = this.executeSoapCall(msg, "", path);
        this.assertResultContains(result, expectedString);
        result = this.executeSoapCall(msg, null, path);
        this.assertResultContains(result, expectedString);
        msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter1>hello world</new:parameter1>  </soapenv:Body></soapenv:Envelope>";
        result = this.executeSoapCall(msg, "", path);
        this.assertResultContains(result, "<new:parameter1");
        result = this.executeSoapCall(msg, null, path);
        this.assertResultContains(result, "<new:parameter1");
    }

    @Test
    public void testServerSoapActionNoWsdl() throws Exception {
        String path = "/services/routeBasedNoWsdl";
        this.msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:new=\"http://new.webservice.namespace\"><soapenv:Header/>  <soapenv:Body>    <new:parameter1>hello world</new:parameter1>  </soapenv:Body></soapenv:Envelope>";
        MuleMessage result = this.executeSoapCall(this.msg, "EchoOperation1", path);
        this.assertResultContains(result, "<new:parameter1");
    }

    private MuleMessage executeSoapCall(String msg, String soapAction, String path) throws MuleException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (soapAction != null) {
            props.put("SOAPAction", soapAction);
        }
        LocalMuleClient client = muleContext.getClient();
        return client.send("http://localhost:" + this.dynamicPort.getNumber() + path, (MuleMessage)new DefaultMuleMessage((Object)msg, props, muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
    }

    private void assertResultContains(MuleMessage result, String expectedString) throws Exception {
        String resString = result.getPayloadAsString();
        System.out.println(resString);
        Assert.assertTrue((String)("message didn't contain the test string: " + expectedString + " but was: " + resString), (resString.indexOf(expectedString) != -1 ? 1 : 0) != 0);
    }

    private void assertResultIsFault(MuleMessage result) throws Exception {
        String resString = result.getPayloadAsString();
        Assert.assertFalse((String)"Status code should not be 'OK' when the proxied endpoint returns a fault", (boolean)String.valueOf(200).equals(result.getOutboundProperty("http.status")));
        Assert.assertTrue((resString.indexOf("Fault") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testOneWaySendWithSoapAction() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/onewayWithSoapAction", (MuleMessage)new DefaultMuleMessage((Object)this.prepareOneWayTestMessage(), this.prepareOneWayWithSoapActionTestProperties(), muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertEquals((Object)"", (Object)result.getPayloadAsString());
        AsyncServiceWithSoapAction component = (AsyncServiceWithSoapAction)this.getComponent("asyncServiceWithSoapAction");
        Assert.assertTrue((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWayDispatchWithSoapAction() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("http://localhost:" + this.dynamicPort.getNumber() + "/services/onewayWithSoapAction", (MuleMessage)new DefaultMuleMessage((Object)this.prepareOneWayTestMessage(), this.prepareOneWayWithSoapActionTestProperties(), muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        AsyncServiceWithSoapAction component = (AsyncServiceWithSoapAction)this.getComponent("asyncServiceWithSoapAction");
        Assert.assertTrue((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWaySendWithSoapActionSpoofing() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/onewayWithSoapAction", (MuleMessage)new DefaultMuleMessage((Object)this.prepareOneWayTestMessage(), this.prepareOneWaySpoofingTestProperties(), muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)result);
        AsyncServiceWithSoapAction component = (AsyncServiceWithSoapAction)this.getComponent("asyncServiceWithSoapAction");
        Assert.assertFalse((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWayDispatchWithSoapActionSpoofing() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("http://localhost:" + this.dynamicPort.getNumber() + "/services/onewayWithSoapAction", (MuleMessage)new DefaultMuleMessage((Object)this.prepareOneWayTestMessage(), this.prepareOneWaySpoofingTestProperties(), muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        AsyncServiceWithSoapAction component = (AsyncServiceWithSoapAction)this.getComponent("asyncServiceWithSoapAction");
        Assert.assertFalse((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWaySendUnknownSoapAction() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/oneway", (MuleMessage)new DefaultMuleMessage((Object)this.prepareOneWayTestMessage(), this.prepareOneWayWithSoapActionTestProperties(), muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)result);
        AsyncService component = (AsyncService)this.getComponent("asyncService");
        Assert.assertFalse((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWayDispatchUnknownSoapAction() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("http://localhost:" + this.dynamicPort.getNumber() + "/services/oneway", (MuleMessage)new DefaultMuleMessage((Object)this.prepareOneWayTestMessage(), this.prepareOneWayWithSoapActionTestProperties(), muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        AsyncService component = (AsyncService)this.getComponent("asyncService");
        Assert.assertFalse((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWaySend() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/oneway", (MuleMessage)new DefaultMuleMessage((Object)this.prepareOneWayTestMessage(), this.prepareOneWayTestProperties(), muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)result);
        AsyncService component = (AsyncService)this.getComponent("asyncService");
        Assert.assertTrue((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testOneWayDispatch() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("http://localhost:" + this.dynamicPort.getNumber() + "/services/oneway", (MuleMessage)new DefaultMuleMessage((Object)this.prepareOneWayTestMessage(), this.prepareOneWayTestProperties(), muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        AsyncService component = (AsyncService)this.getComponent("asyncService");
        Assert.assertTrue((boolean)component.getLatch().await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testProxyWithCommentInRequest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/envelope-proxy", ProxyTestCase.getTestMuleMessage((Object)this.msgWithComment), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)resString.contains(this.doGoogleSearch));
    }

    @Test
    public void testProxyEnvelopeWithXsltTransformation() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/envelope-xslt-proxy", ProxyTestCase.getTestMuleMessage((Object)this.msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertTrue((boolean)result.getPayloadAsString().contains(this.msg));
    }

    @Test
    public void testProxyCDATA() throws Exception {
        String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sup=\"http://support.cxf.module.mule.org/\">\n<soapenv:Header/>\n<soapenv:Body>\n<sup:invoke>\n<soapenv:Envelope>\n<soapenv:Header/>\n<soapenv:Body>\n<sup:invoke>\n<Request>\n<servicePayload><![CDATA[<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"><soapenv:Header/><soapenv:Body><int:test/></soapenv:Body></soapenv:Envelope>]]></servicePayload>\n</Request>\n</sup:invoke>\n</soapenv:Body>\n</soapenv:Envelope>\n</sup:invoke>\n</soapenv:Body>\n</soapenv:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/CDATAService", ProxyTestCase.getTestMuleMessage((Object)msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)StringUtils.countMatches((String)result.getPayloadAsString(), (String)"![CDATA["), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testProxyLongCDATA() throws Exception {
        String SRC_TEXT = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678\r\n<embededElement>Woodstox 4.0.5 does not like this embedded element.  However, if you take\r\nout one or more characters from the really long line (so that less than 500 characters come between\r\n'CDATA[' and the opening of the embeddedElement tag (including LF), then Woodstox will instead\r\ncomplain that the CDATA section wasn't ended.";
        String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sup=\"http://support.cxf.module.mule.org/\">\n<soapenv:Header/>\n<soapenv:Body>\n<sup:invoke>\n<soapenv:Envelope>\n<soapenv:Header/>\n<soapenv:Body>\n<sup:invoke>\n<Request>\n<servicePayload><![CDATA[" + SRC_TEXT + "]]></servicePayload>\n</Request>\n</sup:invoke>\n</soapenv:Body>\n</soapenv:Envelope>\n</sup:invoke>\n</soapenv:Body>\n</soapenv:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/CDATAService", ProxyTestCase.getTestMuleMessage((Object)msg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)StringUtils.countMatches((String)result.getPayloadAsString(), (String)"![CDATA["), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testProxyWithSoapFault() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String proxyFaultMsg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><greetMe xmlns=\"http://apache.org/hello_world_fault/types\"><requestType>Dan</requestType></greetMe></soap:Body></soap:Envelope>";
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/proxyFault", ProxyTestCase.getTestMuleMessage((Object)proxyFaultMsg), (OperationOptions)HTTP_REQUEST_OPTIONS);
        String resString = result.getPayloadAsString();
        Assert.assertTrue((boolean)resString.contains("ERROR"));
    }

    @Test
    public void testProxyJms() throws Exception {
        String payload = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\"><soap:Body><emp:addEmployee xmlns:emp=\"http://employee.example.mule.org/\"><emp:employee><emp:division>Runtime</emp:division><emp:name>Pepe</emp:name></emp:employee></emp:addEmployee></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/proxyJms", ProxyTestCase.getTestMuleMessage((Object)payload), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Matchers.is((Object)payload));
    }

    @Test
    public void testProxyOneWay() throws Exception {
        String body = "<emp:addEmployee xmlns:emp=\"http://employee.example.mule.org/\"><emp:employee><emp:division>Runtime</emp:division><emp:name>Pepe</emp:name></emp:employee></emp:addEmployee>";
        String payload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body>" + body + "</soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/proxyOneWay", ProxyTestCase.getTestMuleMessage((Object)payload), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)result.getInboundProperty("http.status").toString(), (Matcher)Matchers.is((Object)Integer.toString(202)));
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void testProxyOneWayFault() throws Exception {
        String payload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><emp:addEmployee xmlns:emp=\"http://employee.example.mule.org/\"><emp:employee><emp:division>Runtime</emp:division><emp:name>Pepe</emp:name></emp:employee></emp:addEmployee></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/proxyOneWayFault", ProxyTestCase.getTestMuleMessage((Object)payload), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)CoreMatchers.containsString((String)"ERROR"));
    }

    protected String prepareOneWayTestMessage() {
        return "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns:send xmlns:ns=\"http://testmodels.cxf.module.mule.org/\"><text>hello</text></ns:send></soap:Body></soap:Envelope>";
    }

    protected Map<String, Object> prepareOneWayTestProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("SOAPAction", "");
        return props;
    }

    protected Map<String, Object> prepareOneWayWithSoapActionTestProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("SOAPAction", "send");
        return props;
    }

    protected Map<String, Object> prepareOneWaySpoofingTestProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("SOAPAction", "hiddenAction");
        return props;
    }
}

