/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.employee;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.cxf.employee.AttachmentVerifyInterceptor;
import org.mule.module.cxf.employee.EmployeeDirectoryImpl;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class MtomClientTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public MtomClientTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "mtom-client-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "mtom-client-conf-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "mtom-client-conf-flow-httpn.xml"});
    }

    @Test
    public void testEchoService() throws Exception {
        final EmployeeDirectoryImpl svc = (EmployeeDirectoryImpl)this.getComponent("employeeDirectoryService");
        PollingProber prober = new PollingProber(6000L, 500L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                Assert.assertThat((Object)svc.getInvocationCount(), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
                return true;
            }

            public String describeFailure() {
                return "Expected invocation count to be at least 1.";
            }
        });
        Assert.assertTrue((boolean)AttachmentVerifyInterceptor.HasAttachments);
    }

    @Test
    public void nonConformantSoap12MultipartRequestHeader() throws MuleException, IOException {
        String nonConformantContentTypeHeader = "multipart/related; type=\"application/soap+xml\"; boundary=\"uuid:c8f318eb-abd2-4c6c-ac42-1cf785e578a9\"; start=\"<root.message@cxf.apache.org>\"; charset=UTF-8";
        HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = MtomClientTestCase.getTestMuleMessage((Object)"--uuid:c8f318eb-abd2-4c6c-ac42-1cf785e578a9\nContent-Type: application/soap+xml; charset=UTF-8\nContent-Transfer-Encoding: binary\nContent-ID: <root.message@cxf.apache.org>\n\n<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\"><soap:Body><addEmployee xmlns=\"http://employee.example.mule.org/\"><employee><division>Theoretical Physics</division><name>Albert Einstein</name><picture><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:40d88be5-db4c-457b-84d4-a06a83965f34-1@employee.example.mule.org\"/></picture></employee></addEmployee></soap:Body></soap:Envelope>\n--uuid:c8f318eb-abd2-4c6c-ac42-1cf785e578a9\nContent-Type: image/jpeg\nContent-Transfer-Encoding: binary\nContent-ID: <40d88be5-db4c-457b-84d4-a06a83965f34-1@employee.example.mule.org>\nContent-Disposition: attachment;name=\"albert_einstein.jpg\"\n\naaa\n--uuid:c8f318eb-abd2-4c6c-ac42-1cf785e578a9--");
        message.setOutboundProperty("SOAPAction", (Object)"");
        message.setOutboundProperty("Content-Type", (Object)nonConformantContentTypeHeader);
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/services/employeeDirectory12", message, (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertThat((Object)((Integer)result.getInboundProperty("http.status")), (Matcher)CoreMatchers.is((Object)200));
    }
}

