/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.functional;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.api.lifecycle.Callable;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class CxfDataTypeTestCase
extends FunctionalTestCase {
    private static final String requestPayload = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:hi=\"http://example.cxf.module.mule.org/\">\n<soap:Body>\n<hi:sayHi>\n    <arg0>Hello</arg0>\n</hi:sayHi>\n</soap:Body>\n</soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "cxf-datatype-conf.xml";
    }

    @Test
    public void testCxfService() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestPayload, (Map)null, muleContext);
        MuleMessage received = muleContext.getClient().send("http://localhost:" + this.dynamicPort.getNumber() + "/hello", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertThat((Object)received.getPayloadAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Fault")));
    }

    @Test
    public void testCxfClient() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        MuleMessage received = muleContext.getClient().send("vm://helloClient", (MuleMessage)request);
        Assert.assertThat((Object)received.getPayloadAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Fault")));
    }

    @Test
    public void testCxfProxy() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)requestPayload, (Map)null, muleContext);
        MuleMessage received = muleContext.getClient().send("http://localhost:" + this.dynamicPort.getNumber() + "/hello-proxy", (MuleMessage)request, (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertThat((Object)received.getPayloadAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Fault")));
    }

    @Test
    public void testCxfSimpleService() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "application/soap+xml");
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        MuleMessage result = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/echo", (MuleMessage)new DefaultMuleMessage((Object)xml, props, muleContext), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build());
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Fault")));
    }

    @Test
    public void testCxfSimpleClient() throws Exception {
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"hello", (Map)null, muleContext);
        MuleMessage received = muleContext.getClient().send("vm://helloClient", (MuleMessage)request);
        Assert.assertThat((Object)received.getPayloadAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Fault")));
    }

    private static class EnsureDataType
    implements Callable {
        private final String mimeType;

        public EnsureDataType(String mimeType) {
            this.mimeType = mimeType;
        }

        public Object onCall(MuleEventContext eventContext) throws Exception {
            if (!eventContext.getMessage().getDataType().getMimeType().equals(this.mimeType)) {
                throw new RuntimeException();
            }
            return eventContext.getMessage().getPayload();
        }
    }

    public static class EnsureAnyDataType
    extends EnsureDataType {
        public EnsureAnyDataType() {
            super("*/*");
        }
    }

    public static class EnsureXmlDataType
    extends EnsureDataType {
        public EnsureXmlDataType() {
            super("text/xml");
        }
    }
}

