/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import com.google.common.net.MediaType;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleMessage;
import org.mule.module.cxf.support.CxfUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class CxfUtilsTestCase
extends AbstractMuleTestCase {
    @Mock
    private MuleMessage message;

    @Before
    public void setup() {
        Mockito.when((Object)this.message.getEncoding()).thenReturn((Object)StandardCharsets.ISO_8859_1.displayName());
    }

    @Test
    public void resolveEncodingWhenPresentInContentType() throws Exception {
        Assert.assertThat((Object)CxfUtils.resolveEncoding((MuleMessage)this.message, (String)MediaType.PLAIN_TEXT_UTF_8.toString()), (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)StandardCharsets.UTF_8.displayName()));
    }

    @Test
    public void resolveEncodingWhenNotPresentInContentType() throws Exception {
        Assert.assertThat((Object)CxfUtils.resolveEncoding((MuleMessage)this.message, (String)MediaType.APPLICATION_BINARY.toString()), (Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)StandardCharsets.ISO_8859_1.displayName()));
    }
}

