/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.wssec;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.saml.ext.SAMLCallback;
import org.apache.ws.security.saml.ext.bean.AuthenticationStatementBean;
import org.apache.ws.security.saml.ext.bean.KeyInfoBean;
import org.apache.ws.security.saml.ext.bean.SubjectBean;
import org.opensaml.common.SAMLVersion;

public class SAML2CallbackHandler
implements CallbackHandler {
    private X509Certificate[] certs;
    private String subjectName;
    private String subjectQualifier;
    private String confirmationMethod;
    private KeyInfoBean.CERT_IDENTIFIER certIdentifier = KeyInfoBean.CERT_IDENTIFIER.X509_CERT;

    public SAML2CallbackHandler() throws WSSecurityException {
        if (this.certs == null) {
            Crypto crypto = CryptoFactory.getInstance((String)"org/mule/module/cxf/wssec/wssecurity.properties");
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias("joe");
            this.certs = crypto.getX509Certificates(cryptoType);
        }
        this.subjectName = "uid=joe,ou=people,ou=saml-demo,o=example.com";
        this.subjectQualifier = "www.example.com";
        this.confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof SAMLCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            SAMLCallback callback = (SAMLCallback)callbacks[i];
            callback.setSamlVersion(SAMLVersion.VERSION_20);
            SubjectBean subjectBean = new SubjectBean(this.subjectName, this.subjectQualifier, this.confirmationMethod);
            callback.setSubject(subjectBean);
            this.createAndSetStatement(null, callback);
        }
    }

    private void createAndSetStatement(SubjectBean subjectBean, SAMLCallback callback) {
        AuthenticationStatementBean authBean = new AuthenticationStatementBean();
        if (subjectBean != null) {
            authBean.setSubject(subjectBean);
        }
        authBean.setAuthenticationMethod("Password");
        callback.setAuthenticationStatementData(Collections.singletonList(authBean));
    }
}

