/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.wssec;

import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SamlAssertionValidator;

public class SAMLCustomValidator
extends SamlAssertionValidator {
    private boolean requireSenderVouches = true;

    public void setRequireSenderVouches(boolean requireSenderVouches) {
        this.requireSenderVouches = requireSenderVouches;
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        Credential returnedCredential = super.validate(credential, data);
        AssertionWrapper assertion = credential.getAssertion();
        if (!"www.example.com".equals(assertion.getIssuerString())) {
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (assertion.getSaml2() == null) {
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        String confirmationMethod = (String)assertion.getConfirmationMethods().get(0);
        if (confirmationMethod == null) {
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (this.requireSenderVouches && !OpenSAMLUtil.isMethodSenderVouches((String)confirmationMethod)) {
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (!this.requireSenderVouches && !OpenSAMLUtil.isMethodHolderOfKey((String)confirmationMethod)) {
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (!"uid=joe,ou=people,ou=saml-demo,o=example.com".equals(assertion.getSaml2().getSubject().getNameID().getValue())) {
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        return returnedCredential;
    }
}

