/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.junit.Before;
import org.mule.module.http.api.HttpConstants;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.ssl.DefaultTlsContextFactory;

public class AbstractHttpSecurityTestCase
extends AbstractServiceAndFlowTestCase {
    public AbstractHttpSecurityTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Before
    public void setUp() throws Exception {
        DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory();
        tlsContextFactory.setTrustStorePath("trustStore");
        tlsContextFactory.setTrustStorePassword("mulepassword");
        tlsContextFactory.initialise();
        SSLSocketFactory factory = tlsContextFactory.createSslContext().getSocketFactory();
        Protocol httpsWithTrustStore = new Protocol(HttpConstants.Protocols.HTTPS.getScheme(), AbstractHttpSecurityTestCase.getSocketFactory(factory), HttpConstants.Protocols.HTTPS.getDefaultPort());
        Protocol.registerProtocol((String)HttpConstants.Protocols.HTTPS.getScheme(), (Protocol)httpsWithTrustStore);
    }

    private static ProtocolSocketFactory getSocketFactory(final SSLSocketFactory factory) {
        return new ProtocolSocketFactory(){
            private SSLSocketFactory socketFactory;
            {
                this.socketFactory = factory;
            }

            public Socket createSocket(String host, int port) throws IOException {
                return this.socketFactory.createSocket(host, port);
            }

            public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
                return this.socketFactory.createSocket(host, port, localAddress, localPort);
            }

            public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
                return this.createSocket(host, port, localAddress, localPort);
            }
        };
    }
}

