/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.FunctionalTestNotification;
import org.mule.tck.functional.FunctionalTestNotificationListener;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

public class CxfCustomHttpHeaderTestCase
extends AbstractServiceAndFlowTestCase
implements FunctionalTestNotificationListener {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    private static final String REQUEST_PAYLOAD = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n<soap:Body>\n<ns1:onReceive xmlns:ns1=\"http://functional.tck.mule.org/\">\n    <ns1:arg0 xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:string\">Test String</ns1:arg0>\n</ns1:onReceive>\n</soap:Body>\n</soap:Envelope>";
    private static final String SOAP_RESPONSE = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns1:onReceiveResponse xmlns:ns1=\"http://functional.tck.mule.org/\"><ns1:return xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:string\">Test String Received</ns1:return></ns1:onReceiveResponse></soap:Body></soap:Envelope>";
    private List<MuleMessage> notificationMsgList = new ArrayList<MuleMessage>();
    private Latch latch = new Latch();
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public CxfCustomHttpHeaderTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "headers-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "headers-conf-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "headers-conf-flow-httpn.xml"});
    }

    protected void doSetUp() throws Exception {
        muleContext.registerListener((ServerNotificationListener)this);
    }

    protected void doTearDown() throws Exception {
        muleContext.unregisterListener((ServerNotificationListener)this);
    }

    @Test
    public void testCxf() throws Exception {
        String endpointAddress = "http://localhost:" + this.dynamicPort.getValue() + "/services/TestComponent";
        String myProperty = "myProperty";
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_USER", "alan");
        props.put("method", "onReceive");
        props.put(myProperty, myProperty);
        MuleMessage reply = muleContext.getClient().send(String.format(endpointAddress, new Object[0]), (MuleMessage)new DefaultMuleMessage((Object)REQUEST_PAYLOAD, props, muleContext), (OperationOptions)HTTP_REQUEST_OPTIONS);
        Assert.assertNotNull((Object)reply);
        Assert.assertNotNull((Object)reply.getPayload());
        Assert.assertEquals((Object)SOAP_RESPONSE, (Object)reply.getPayloadAsString());
        this.latch.await(3000L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)this.notificationMsgList.size());
        Assert.assertEquals((Object)"alan", (Object)this.notificationMsgList.get(0).getInboundProperty("MULE_USER"));
        Assert.assertNull((Object)this.notificationMsgList.get(0).getInboundProperty("MULE_IGNORE_METHOD"));
        Assert.assertEquals((Object)myProperty, (Object)this.notificationMsgList.get(0).getInboundProperty(myProperty));
    }

    public void onNotification(ServerNotification notification) {
        if (notification instanceof FunctionalTestNotification) {
            this.notificationMsgList.add(((FunctionalTestNotification)notification).getEventContext().getMessage());
            this.latch.release();
        } else {
            Assert.fail((String)("invalid notification: " + notification));
        }
    }
}

