/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.simple.EchoService;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.module.cxf.CxfOutboundMessageProcessor;
import org.mule.module.cxf.builder.SimpleClientMessageProcessorBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class CxfOutboundMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><ns1:echo xmlns:ns1=\"http://simple.component.api.mule.org/\"><ns1:return>hello</ns1:return></ns1:echo></soap:Body></soap:Envelope>";
    boolean gotEvent = false;
    Object payload;

    @Test
    public void testOutbound() throws Exception {
        CxfConfiguration config = new CxfConfiguration();
        config.setMuleContext(muleContext);
        config.initialise();
        SimpleClientMessageProcessorBuilder builder = new SimpleClientMessageProcessorBuilder();
        builder.setConfiguration(config);
        builder.setServiceClass(EchoService.class);
        builder.setOperation("echo");
        builder.setMuleContext(muleContext);
        CxfOutboundMessageProcessor processor = (CxfOutboundMessageProcessor)Mockito.spy((Object)builder.build());
        MessageProcessor messageProcessor = new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                CxfOutboundMessageProcessorTestCase.this.payload = event.getMessage().getPayload();
                try {
                    System.out.println(event.getMessage().getPayloadAsString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                event.getMessage().setPayload((Object)CxfOutboundMessageProcessorTestCase.this.msg);
                CxfOutboundMessageProcessorTestCase.this.gotEvent = true;
                return event;
            }
        };
        processor.setListener(messageProcessor);
        MuleEvent event = CxfOutboundMessageProcessorTestCase.getTestEvent((Object)"hello", (InboundEndpoint)CxfOutboundMessageProcessorTestCase.getTestInboundEndpoint((MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE));
        MuleEvent response = processor.process(event);
        Assert.assertThat(processor.getClient().getRequestContext().entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((Boolean)processor.getClient().getRequestContext().get("thread.local.request.context")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)processor.getClient().getResponseContext().isEmpty(), (Matcher)Is.is((Object)true));
        Object payload = response.getMessage().getPayload();
        Assert.assertThat((Object)payload, (Matcher)IsInstanceOf.instanceOf(String.class));
        ((CxfOutboundMessageProcessor)Mockito.verify((Object)processor)).resetAccessControlIfNonBlocking(event);
        Assert.assertThat((Object)((String)payload), (Matcher)Is.is((Object)"hello"));
        Assert.assertThat((Object)this.gotEvent, (Matcher)Is.is((Object)true));
    }
}

