/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.Servlet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.servlet.MuleReceiverServlet;
import org.mule.transport.servlet.jetty.util.EmbeddedJettyServer;

public class ServletTestCase
extends AbstractServiceAndFlowTestCase {
    public int HTTP_PORT = -1;
    private EmbeddedJettyServer httpServer;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public ServletTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "servlet-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "servlet-conf-flow.xml"});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.HTTP_PORT = this.dynamicPort.getNumber();
        this.httpServer = new EmbeddedJettyServer(this.HTTP_PORT, this.getContextPath(), "/services/*", (Servlet)new MuleReceiverServlet(), muleContext);
        this.httpServer.start();
    }

    protected String getContextPath() {
        return "";
    }

    protected void doTearDown() throws Exception {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.stop();
        }
        super.doTearDown();
    }

    @Test
    public void testRequestWsdlWithServlets() throws Exception {
        String request = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body><ns1:echo xmlns:ns1=\"http://testmodels.cxf.module.mule.org/\"><text>Test String</text></ns1:echo></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("http://localhost:" + this.HTTP_PORT + this.getContextPath() + "/services/mycomponent", ServletTestCase.getTestMuleMessage((Object)request));
        String res = result.getPayloadAsString();
        Assert.assertTrue((res.indexOf("Test String") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testHttpGet() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.method", "GET");
        MuleMessage result = client.send("http://localhost:" + this.HTTP_PORT + this.getContextPath() + "/services/mycomponent/echo/text/Test String", (MuleMessage)new DefaultMuleMessage((Object)"", props, muleContext));
        String res = result.getPayloadAsString();
        Assert.assertTrue((res.indexOf("Test String") != -1 ? 1 : 0) != 0);
    }
}

