/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.MessagePartInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.module.cxf.support.OutputPayloadInterceptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class OutputPayloadInterceptorTestCase
extends AbstractMuleTestCase {
    private OutputPayloadInterceptor interceptor;

    @Before
    public void setUpInterceptor() {
        this.interceptor = new OutputPayloadInterceptor();
    }

    @Test
    public void testCleanUpPayload_NotAnArray() throws Exception {
        ArrayList someList = new ArrayList();
        Assert.assertSame(someList, (Object)this.interceptor.cleanUpPayload(someList));
        String someString = "Some String";
        Assert.assertSame((Object)"Some String", (Object)this.interceptor.cleanUpPayload((Object)"Some String"));
    }

    @Test
    public void testCleanUpPayload_NonObjectArray() throws Exception {
        String someString = "Some String";
        Assert.assertSame((Object)"Some String", (Object)this.interceptor.cleanUpPayload((Object)new String[]{"Some String", null}));
        String[] arrayOf2Strings = new String[]{"Some String", "someOther String"};
        Assert.assertSame((Object)arrayOf2Strings, (Object)this.interceptor.cleanUpPayload((Object)arrayOf2Strings));
        String[] arrayOf2Strings1Null = new String[]{"Some String", "someOther String", null};
        Assert.assertTrue((boolean)Arrays.equals(new String[]{arrayOf2Strings1Null[0], arrayOf2Strings1Null[1]}, (Object[])this.interceptor.cleanUpPayload((Object)arrayOf2Strings1Null)));
    }

    @Test
    public void testCleanUpPayload_ArrayOfObjects() {
        Integer someInteger = 1;
        Assert.assertSame((Object)someInteger, (Object)this.interceptor.cleanUpPayload((Object)new Object[]{someInteger, null}));
        Object[] arrayOf2Objects = new Object[]{someInteger, new Object()};
        Assert.assertSame((Object)arrayOf2Objects, (Object)this.interceptor.cleanUpPayload((Object)arrayOf2Objects));
        Object[] arrayOf2Objects1Null = new Object[]{someInteger, null, new Object(), MessageContentsList.REMOVED_MARKER};
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{arrayOf2Objects1Null[0], arrayOf2Objects1Null[2]}, (Object[])this.interceptor.cleanUpPayload((Object)arrayOf2Objects1Null)));
    }

    @Test
    public void testAddsMissingPartContentOnHandleMessage() {
        MessageContentsList messageContentsList = new MessageContentsList();
        Object content1 = new Object();
        messageContentsList.add(content1);
        ArrayList<MessagePartInfo> parts = new ArrayList<MessagePartInfo>();
        MessagePartInfo part1 = new MessagePartInfo(new QName("part1"), null);
        part1.setIndex(1);
        parts.add(part1);
        this.interceptor.ensurePartIndexMatchListIndex(messageContentsList, parts);
        Assert.assertEquals((long)2L, (long)messageContentsList.size());
        Assert.assertEquals(null, (Object)messageContentsList.get(0));
        Assert.assertEquals((Object)content1, (Object)messageContentsList.get(1));
    }

    @Test
    public void testAddsMissingPartContentWithUnsortedPartListOnHandleMessage() {
        MessageContentsList messageContentsList = new MessageContentsList();
        Object content1 = new Object();
        messageContentsList.add(content1);
        Object content2 = new Object();
        messageContentsList.add(content2);
        ArrayList<MessagePartInfo> parts = new ArrayList<MessagePartInfo>();
        MessagePartInfo part2 = new MessagePartInfo(new QName("part2"), null);
        part2.setIndex(3);
        parts.add(part2);
        MessagePartInfo part1 = new MessagePartInfo(new QName("part1"), null);
        part1.setIndex(1);
        parts.add(part1);
        this.interceptor.ensurePartIndexMatchListIndex(messageContentsList, parts);
        Assert.assertEquals((long)4L, (long)messageContentsList.size());
        Assert.assertEquals(null, (Object)messageContentsList.get(0));
        Assert.assertEquals((Object)content1, (Object)messageContentsList.get(1));
        Assert.assertEquals(null, (Object)messageContentsList.get(2));
        Assert.assertEquals((Object)content2, (Object)messageContentsList.get(3));
    }
}

