/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class CxfComponentExceptionStrategyTestCase
extends AbstractServiceAndFlowTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    private static final String REQUEST_PAYLOAD = "<soap:Envelope \n           xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"\n           xmlns:svc=\"http://example.cxf.module.mule.org/\">\n<soap:Body>\n<svc:##method##>\n    <arg0>Test</arg0>\n</svc:##method##>\n</soap:Body>\n</soap:Envelope>";
    private static final String SOAP_FAULT = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><soap:Fault><faultcode>soap:Server</faultcode><faultstring>%s</faultstring></soap:Fault></soap:Body></soap:Envelope>";
    private static final String CUSTOM_SOAP_FAULT = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><soap:Fault><faultcode>soap:Server</faultcode><faultstring>Cxf Exception Message</faultstring><detail><ns1:CustomFault xmlns:ns1=\"http://testmodels.cxf.module.mule.org/\"><ns2:description xmlns:ns2=\"http://testmodels.cxf.module.mule.org\">%s</ns2:description></ns1:CustomFault></detail></soap:Fault></soap:Body></soap:Envelope>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public CxfComponentExceptionStrategyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "exception-strategy-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "exception-strategy-conf-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "exception-strategy-conf-flow-httpn.xml"});
    }

    @Test
    public void testDefaultComponentExceptionStrategyWithFault() throws Exception {
        this.doTest("CxfWithExceptionStrategy", "testFault", SOAP_FAULT, "Invalid data argument");
    }

    @Test
    public void testDefaultExceptionStrategyWithFault() throws Exception {
        this.doTest("CxfWithDefaultExceptionStrategy", "testFault", SOAP_FAULT, "Invalid data argument");
    }

    @Test
    public void testDefaultComponentExceptionStrategyWithCxfException() throws Exception {
        this.doTest("CxfWithExceptionStrategy", "testCxfException", CUSTOM_SOAP_FAULT, "Custom Exception Message");
    }

    @Test
    public void testDefaultExceptionStrategyWithCxfException() throws Exception {
        this.doTest("CxfWithDefaultExceptionStrategy", "testCxfException", CUSTOM_SOAP_FAULT, "Custom Exception Message");
    }

    @Test
    public void testDefaultComponentExceptionStrategyWithException() throws Exception {
        this.doTest("CxfWithExceptionStrategy", "testNonCxfException", SOAP_FAULT, "Non-Cxf Enabled Exception");
    }

    @Test
    public void testDefaultExceptionStrategyWithException() throws Exception {
        this.doTest("CxfWithDefaultExceptionStrategy", "testNonCxfException", SOAP_FAULT, "Non-Cxf Enabled Exception");
    }

    private void doTest(String path, String soapMethod, String faultTemplate, String faultMessage) throws Exception {
        MuleMessage response = muleContext.getClient().send(String.format("http://localhost:%d/services/%s", this.dynamicPort.getNumber(), path), CxfComponentExceptionStrategyTestCase.getTestMuleMessage((Object)this.getRequestPayload(soapMethod)), (OperationOptions)HTTP_REQUEST_OPTIONS);
        this.assertFault(faultTemplate, response.getPayloadAsString(), faultMessage);
    }

    private String getRequestPayload(String method) {
        return REQUEST_PAYLOAD.replaceAll("##method##", method);
    }

    private void assertFault(String faultTemplate, String soapResponse, String faultMessage) {
        Assert.assertEquals((Object)String.format(faultTemplate, faultMessage), (Object)soapResponse);
    }
}

