/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

@RunWith(value=Parameterized.class)
public class CxfWsdlImportsTestCase
extends FunctionalTestCase {
    private static final String VALID_REQUEST_ECHO = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <echo xmlns=\"http://www.echo.org\"><echo>Testing echo</echo></echo></soap:Body></soap:Envelope>";
    private static final String INVALID_REQUEST_ECHO = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body> <wrongEcho xmlns=\"http://www.echo.org\">  <echo>Testing echo</ech></wrongEcho></soap:Body></soap:Envelope>";
    private static final String VALID_REQUEST_LOG = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:log=\"http://www.log.org\"><soapenv:Body><log:log><log:message>Testing Log</log:message></log:log></soapenv:Body></soapenv:Envelope>";
    private static final String INVALID_REQUEST_LOG = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:log=\"http://www.muleumo.org\"><soapenv:Body><log:wrongLog><log:message>Testing Log</log:message></log:wrongLog></soapenv:Body></soapenv:Envelope>";
    private static final String ECHO_TEST_ERROR_MESSAGE = "tag name \"wrongEcho\" is not allowed";
    private static final String LOG_TEST_ERROR_MESSAGE = "tag name \"wrongLog\" is not allowed";
    @Rule
    public final DynamicPort httpPort = new DynamicPort("port1");
    @Parameterized.Parameter
    public String validPayload;
    @Parameterized.Parameter(value=1)
    public String invalidPayload;
    @Parameterized.Parameter(value=2)
    public String errorMessage;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({VALID_REQUEST_ECHO, INVALID_REQUEST_ECHO, ECHO_TEST_ERROR_MESSAGE}, {VALID_REQUEST_LOG, INVALID_REQUEST_LOG, LOG_TEST_ERROR_MESSAGE});
    }

    protected String getConfigFile() {
        return "proxy-validation-imports-config.xml";
    }

    @Test
    public void testValidRequest() throws Exception {
        MuleMessage response = muleContext.getClient().send("http://localhost:" + this.httpPort.getNumber() + "/services/test", CxfWsdlImportsTestCase.getTestMuleMessage((Object)this.validPayload));
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)CoreMatchers.is((Object)this.validPayload));
    }

    @Test
    public void testInvalidRequest() throws Exception {
        MuleMessage response = muleContext.getClient().send("http://localhost:" + this.httpPort.getNumber() + "/services/test", CxfWsdlImportsTestCase.getTestMuleMessage((Object)this.invalidPayload));
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)CoreMatchers.containsString((String)this.errorMessage));
    }
}

