/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.w3c.dom.Document;

public class CxfWsdlTestCase
extends AbstractMuleContextTestCase {
    public static final String TEST_URL = "wsdl-cxf:http://localhost:8080/mule-tests-external-cxf/services/TestService?WSDL&method=getTest";
    public static final String TEST_URL_NOWSDL = "wsdl-cxf:http://localhost:8080/mule-tests-external-cxf/services/TestService?method=getTest";
    public static final String TEST_URL_WSDL = "http://localhost:8080/mule-tests-external-cxf/services/TestService?wsdl";

    @Test
    public void testCxfWsdlService() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = CxfWsdlTestCase.getTestMuleMessage((Object)"test1");
        MuleMessage reply = client.send(TEST_URL, message);
        Assert.assertNotNull((Object)reply);
        Document response = (Document)reply.getPayload();
        Assert.assertNotNull((Object)response);
        XMLAssert.assertXpathEvaluatesTo((String)"test1", (String)"//*[namespace-uri()='http://applications.external.tck.mule.org' and local-name()='key']", (Document)response);
    }

    @Test
    public void testCxfWsdlServiceWithEndpointParam() throws Exception {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(TEST_URL_NOWSDL, muleContext);
        endpointBuilder.setProperty((Object)"wsdlUrl", (Object)TEST_URL_WSDL);
        OutboundEndpoint endpoint = muleContext.getEndpointFactory().getOutboundEndpoint((EndpointBuilder)endpointBuilder);
        MuleMessage message = CxfWsdlTestCase.getTestMuleMessage((Object)"test1");
        DefaultMuleEvent event = new DefaultMuleEvent(message, endpoint.getExchangePattern(), (FlowConstruct)null);
        MuleMessage reply = endpoint.process((MuleEvent)event).getMessage();
        Assert.assertNotNull((Object)reply);
        Document response = (Document)reply.getPayload();
        Assert.assertNotNull((Object)response);
        XMLAssert.assertXpathEvaluatesTo((String)"test1", (String)"//*[namespace-uri()='http://applications.external.tck.mule.org' and local-name()='key']", (Document)response);
    }
}

