/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.cxf.helpers.DOMUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.MuleClient;
import org.mule.module.xml.stax.StaxSource;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DirectXmlTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public DirectXmlTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "direct/direct-xml-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "direct/direct-xml-conf-flow.xml"});
    }

    @Test
    public void testInputStream() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        Assert.assertThat((Object)xml, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        this.test((MuleClient)client, xml);
    }

    @Test
    public void testInputStreamWithXslt() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        Assert.assertNotNull((Object)xml);
        MuleMessage result = client.send("vm://echoWithTransform", (Object)xml, null);
        String resultStr = result.getPayloadAsString();
        Assert.assertThat((String)("echoResponse not found in result: " + resultStr), (Object)result.getPayloadAsString(), (Matcher)CoreMatchers.containsString((String)"echoResponse"));
    }

    private void test(MuleClient client, Object xml) throws MuleException, Exception {
        MuleMessage result = client.send("vm://echo", xml, null);
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)CoreMatchers.containsString((String)"echoResponse"));
    }

    @Test
    public void testDom() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        Document dom = DOMUtils.readXml((InputStream)xml);
        this.test((MuleClient)client, dom);
    }

    @Test
    public void testDomSource() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        Document dom = DOMUtils.readXml((InputStream)xml);
        this.test((MuleClient)client, new DOMSource(dom));
    }

    @Test
    public void testSAXSource() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        SAXSource source = new SAXSource(new InputSource(xml));
        this.test((MuleClient)client, source);
    }

    @Test
    public void testStaxSource() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(xml);
        this.test((MuleClient)client, new StaxSource(reader));
    }

    @Test
    public void testXMLStreamReader() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("/direct/direct-request.xml");
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(xml);
        this.test((MuleClient)client, reader);
    }
}

