/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.util.Arrays;
import java.util.Collection;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.cxf.wssec.ClientPasswordCallback;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

@RunWith(value=Parameterized.class)
public class UsernameTokenProxyWithoutMustUnderstandTestCase
extends FunctionalTestCase {
    private static final HttpRequestOptions HTTP_REQUEST_OPTIONS = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    @Rule
    public final DynamicPort httpPortProxy = new DynamicPort("port1");
    private String request;
    private String response;
    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"cxf-proxy-service-without-mustunderstand-flow.xml"}, {"cxf-proxy-service-without-mustunderstand-flow-httpn.xml"});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Before
    public void doSetUp() throws Exception {
        this.request = IOUtils.getResourceAsString((String)"in-message-with-mustunderstand.xml", ((Object)((Object)this)).getClass());
        this.response = IOUtils.getResourceAsString((String)"out-message-with-mustunderstand.xml", ((Object)((Object)this)).getClass());
        ClientPasswordCallback.setPassword("secret");
        super.doSetUp();
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @Test
    public void testProxyServiceWithoutMustUnderstand() throws Exception {
        MuleMessage replyMessage = this.sendRequest("http://localhost:" + this.httpPortProxy.getNumber() + "/proxy-envelope", this.request);
        Assert.assertNotNull((Object)replyMessage);
        Assert.assertFalse((boolean)replyMessage.getPayloadAsString().contains("Fault"));
        Assert.assertTrue((boolean)XMLUnit.compareXML((String)this.response, (String)replyMessage.getPayload().toString()).identical());
    }

    protected MuleMessage sendRequest(String url, String payload) throws MuleException {
        return muleContext.getClient().send(url, UsernameTokenProxyWithoutMustUnderstandTestCase.getTestMuleMessage((Object)payload), (OperationOptions)HTTP_REQUEST_OPTIONS);
    }
}

