/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.db.internal.result.statement;

import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.result.resultset.ResultSetHandler;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

/**
 * Processes {@link Statement} results creating a map containing them.
 */
public abstract class AbstractMapStatementResultHandler implements StatementResultHandler
{

    private final ResultSetHandler resultSetHandler;

    public AbstractMapStatementResultHandler(ResultSetHandler resultSetHandler)
    {
        this.resultSetHandler = resultSetHandler;
    }

    @Override
    public Object processStatement(DbConnection connection, Statement statement, QueryTemplate queryTemplate, AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) throws SQLException
    {
        Map<String, Object> result = createResultMap();

        StatementResultIteratorFactory statementResultIteratorFactory = connection.getStatementResultIteratorFactory(resultSetHandler);
        StatementResultIterator statementResultIterator = statementResultIteratorFactory.create(connection, statement, queryTemplate, autoGeneratedKeyStrategy);


        while (statementResultIterator.hasNext())
        {
            StatementResult next = statementResultIterator.next();

            result.put(next.getName(), next.getResult());
        }

        return result;
    }

    protected abstract Map<String, Object> createResultMap();
}
