/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.config;

import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.DerbyTestDatabase;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.TransactionalDbConnectionFactory;
import org.mule.module.db.internal.domain.database.GenericDbConfig;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;

public class CustomDbTypeConfigTestCase
extends AbstractDbIntegrationTestCase {
    public static final String CUSTOM_TYPE_NAME1 = "CUSTOM_TYPE1";
    public static final int CUSTOM_TYPE_ID1 = 3001;
    public static final String CUSTOM_TYPE_NAME2 = "CUSTOM_TYPE2";
    public static final int CUSTOM_TYPE_ID2 = 3002;

    public CustomDbTypeConfigTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return Collections.singletonList(new Object[]{"integration/config/custom-type-db-config.xml", new DerbyTestDatabase()});
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resolvesCustomDbTypes() throws Exception {
        GenericDbConfig dbConfig = (GenericDbConfig)muleContext.getRegistry().lookupObject("dbConfig");
        DbTypeManager dbTypeManager = dbConfig.getDbTypeManager();
        TransactionalDbConnectionFactory connectionFactory = dbConfig.getConnectionFactory();
        DbConnection connection = connectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED);
        try {
            this.assertResolvesType(connection, dbTypeManager, CUSTOM_TYPE_NAME1, 3001);
            this.assertResolvesType(connection, dbTypeManager, CUSTOM_TYPE_NAME2, 3002);
        }
        finally {
            connectionFactory.releaseConnection(connection);
        }
    }

    protected void assertResolvesType(DbConnection connection, DbTypeManager dbTypeManager, String name, int id) {
        DbType cursor = dbTypeManager.lookup(connection, name);
        Assert.assertThat((Object)name, (Matcher)CoreMatchers.equalTo((Object)cursor.getName()));
        Assert.assertThat((Object)id, (Matcher)CoreMatchers.equalTo((Object)cursor.getId()));
    }
}

