/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.config;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JdbcParamTypeTestCase
extends AbstractMuleTestCase {
    private static final List<String> schemaJdbcTypes = JdbcParamTypeTestCase.getSchemaJdbcTypes();

    @Test
    public void definesJdbcTypesInSchemaValues() throws Exception {
        HashSet<String> schemaJdbcTypes = new HashSet<String>();
        for (String schemaType : JdbcParamTypeTestCase.getSchemaJdbcTypes()) {
            schemaJdbcTypes.add(schemaType);
        }
        for (DbType dbType : JdbcTypes.types) {
            Assert.assertThat((Object)schemaJdbcTypes.contains(dbType.getName()), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void definesSchemaValueInJdbcTypes() throws Exception {
        HashSet<String> jdbcTypes = new HashSet<String>();
        for (DbType dbType : JdbcTypes.types) {
            jdbcTypes.add(dbType.getName());
        }
        for (String schemaJdbcType : schemaJdbcTypes) {
            Assert.assertThat((Object)jdbcTypes.contains(schemaJdbcType), (Matcher)Is.is((Object)true));
        }
    }

    private static List<String> getSchemaJdbcTypes() {
        try {
            ArrayList<String> schemaTypes = new ArrayList<String>();
            Document doc = JdbcParamTypeTestCase.parseSchema("/META-INF/mule-db.xsd");
            Element jdbcTypes = JdbcParamTypeTestCase.findSimpleType(doc, "JdbcDataTypes");
            NodeList childNodes = jdbcTypes.getElementsByTagName("xsd:restriction");
            Element type = (Element)childNodes.item(0);
            NodeList enums = type.getElementsByTagName("xsd:enumeration");
            for (int i = 0; i < enums.getLength(); ++i) {
                Element currentElement = (Element)enums.item(i);
                schemaTypes.add(currentElement.getAttribute("value"));
            }
            return schemaTypes;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to configure parameterized test", e);
        }
    }

    private static Element findSimpleType(Document doc, String typeName) {
        NodeList simpleTypes = doc.getElementsByTagName("xsd:simpleType");
        for (int i = 0; i < simpleTypes.getLength(); ++i) {
            Element simpleType = (Element)simpleTypes.item(i);
            if (!typeName.equals(simpleType.getAttribute("name"))) continue;
            return simpleType;
        }
        throw new IllegalStateException(String.format("Unable to locate element for simple type '%s", typeName));
    }

    private static Document parseSchema(String schema) throws Exception {
        URL resource = JdbcParamTypeTestCase.class.getResource(schema);
        File file = new File(resource.toURI());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.parse(file);
    }
}

