/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.delete;

import java.sql.SQLException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Planet;

public class DeleteSourceTestCase
extends AbstractDbIntegrationTestCase {
    public DeleteSourceTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/delete/delete-source-config.xml"};
    }

    @Test
    public void usesDefaultSource() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://delete", (Object)Planet.VENUS.getName(), null);
        this.assertDelete(response);
    }

    @Test
    public void usesCustomSource() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://deleteCustomSource", (Object)"Test Message", null);
        this.assertDelete(response);
    }

    private void assertDelete(MuleMessage response) throws SQLException {
        Assert.assertEquals((Object)1, (Object)response.getPayload());
        this.assertDeletedPlanetRecords(Planet.VENUS.getName());
    }
}

