/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.insert;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultParameterizedMapMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.SimpleMetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.construct.Flow;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.processor.PreparedBulkUpdateMessageProcessor;

public class InsertBulkOutputMetadataTestCase
extends AbstractDbIntegrationTestCase {
    public InsertBulkOutputMetadataTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/insert/insert-bulk-output-metadata-config.xml"};
    }

    @Test
    public void returnsInsertBulkMetadata() throws Exception {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct("insertBulkMetadata");
        List messageProcessors = flowConstruct.getMessageProcessors();
        PreparedBulkUpdateMessageProcessor queryMessageProcessor = (PreparedBulkUpdateMessageProcessor)messageProcessors.get(0);
        Result outputMetaData = queryMessageProcessor.getOutputMetaData(null);
        DefaultListMetaDataModel listMetaDataModel = (DefaultListMetaDataModel)((MetaData)outputMetaData.get()).getPayload();
        Assert.assertThat((Object)listMetaDataModel.isArray(), (Matcher)CoreMatchers.equalTo((Object)true));
        SimpleMetaDataModel elementModel = (SimpleMetaDataModel)listMetaDataModel.getElementModel();
        Assert.assertThat((Object)elementModel.getDataType(), (Matcher)CoreMatchers.equalTo((Object)DataType.DOUBLE));
    }

    @Test
    public void returnsInsertBulkAutoGeneratedKeysMetadata() throws Exception {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct("insertBulkAutoGeneratedKeysMetadata");
        List messageProcessors = flowConstruct.getMessageProcessors();
        PreparedBulkUpdateMessageProcessor queryMessageProcessor = (PreparedBulkUpdateMessageProcessor)messageProcessors.get(0);
        Result outputMetaData = queryMessageProcessor.getOutputMetaData(null);
        DefaultListMetaDataModel listMetaDataModel = (DefaultListMetaDataModel)((MetaData)outputMetaData.get()).getPayload();
        Assert.assertThat((Object)listMetaDataModel.isArray(), (Matcher)CoreMatchers.equalTo((Object)true));
        DefaultListMetaDataModel innerListMetaDataModel = (DefaultListMetaDataModel)listMetaDataModel.getElementModel();
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)innerListMetaDataModel.getImplementationClass());
        DefaultParameterizedMapMetaDataModel mapMetaDataModel = (DefaultParameterizedMapMetaDataModel)innerListMetaDataModel.getElementModel();
        Assert.assertEquals((Object)DataType.STRING, (Object)mapMetaDataModel.getKeyMetaDataModel().getDataType());
        Assert.assertEquals((Object)DataType.POJO, (Object)mapMetaDataModel.getValueMetaDataModel().getDataType());
    }
}

