/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.update;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Planet;
import org.mule.module.db.integration.model.Record;
import org.mule.transport.NullPayload;

public class UpdateBulkTestCase
extends AbstractDbIntegrationTestCase {
    public UpdateBulkTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/update/update-bulk-config.xml"};
    }

    @Test
    public void updatesInBulkMode() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        ArrayList<String> planetNames = new ArrayList<String>();
        planetNames.add(Planet.VENUS.getName());
        planetNames.add(Planet.MARS.getName());
        planetNames.add(Planet.EARTH.getName());
        MuleMessage response = client.send("vm://updateBulk", planetNames, null);
        this.assertBulkModeResult(response);
    }

    @Test
    public void requiresCollectionPayload() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://updateBulk", (Object)"Test Message", null);
        Assert.assertTrue((boolean)(response.getPayload() instanceof NullPayload));
        Assert.assertNotNull((Object)response.getExceptionPayload());
    }

    private void assertBulkModeResult(MuleMessage response) throws SQLException {
        Assert.assertTrue((boolean)(response.getPayload() instanceof int[]));
        int[] counters = (int[])response.getPayload();
        Assert.assertThat((Object)counters[0], (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)1), CoreMatchers.equalTo((Object)-2)}));
        Assert.assertThat((Object)counters[1], (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)1), CoreMatchers.equalTo((Object)-2)}));
        Assert.assertThat((Object)counters[2], (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)1), CoreMatchers.equalTo((Object)-2)}));
        List<Map<String, String>> result = DbTestUtil.selectData("select * from PLANET order by ID", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 2)), new Record(new Field("NAME", "Mercury"), new Field("POSITION", 3)), new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }
}

