/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.vendor.oracle;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Alien;
import org.mule.module.db.integration.model.Record;
import org.mule.module.db.integration.model.XmlField;
import org.mule.module.db.integration.vendor.oracle.AbstractOracleXmlTypeTestCase;
import org.mule.module.db.integration.vendor.oracle.XmlTypeUtils;

public class OracleStoredProcedureXmlParamTestCase
extends AbstractOracleXmlTypeTestCase {
    public static final String DESCRIPTION_FIELD = "description";

    public OracleStoredProcedureXmlParamTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getOracleResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/vendor/oracle/oracle-stored-procedure-xml-type-param-config.xml"};
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        this.testDatabase.createStoredProcedureGetAlienDescription(this.getDefaultDataSource());
        this.testDatabase.createStoredProcedureUpdateAlienDescription(this.getDefaultDataSource());
    }

    @Test
    public void returnsXmlTypeOutputParam() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://xmlTypeOutputParam", (Object)"ET", null);
        Assert.assertThat((Object)response.getPayload(), (Matcher)Is.is(Map.class));
        Map mapPayload = (Map)response.getPayload();
        TestRecordUtil.assertRecord(new Record(new XmlField(DESCRIPTION_FIELD, Alien.ET.getXml())), new Record(mapPayload));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void acceptsXmlTypeInputParam() throws Exception {
        DataSource defaultDataSource = this.getDefaultDataSource();
        Connection connection = defaultDataSource.getConnection();
        try {
            Object xmlType = XmlTypeUtils.createXmlType(connection, Alien.ET.getXml());
            LocalMuleClient client = muleContext.getClient();
            HashMap<String, Object> messageProperties = new HashMap<String, Object>();
            messageProperties.put("name", "Monguito");
            messageProperties.put(DESCRIPTION_FIELD, xmlType);
            MuleMessage response = client.send("vm://xmlTypeInputParam", (Object)"Test Message", messageProperties);
            Assert.assertThat((Object)response.getPayload(), (Matcher)Is.is(Map.class));
            Map mapPayload = (Map)response.getPayload();
            Assert.assertThat((Object)mapPayload.size(), (Matcher)CoreMatchers.equalTo((Object)0));
            this.assertUpdatedAlienDscription();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

