/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.parser;

import org.junit.Assert;
import org.junit.Test;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.parser.QueryTemplateParsingException;
import org.mule.module.db.internal.parser.SimpleQueryTemplateParser;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SimpleQueryTemplateParserTestCase
extends AbstractMuleTestCase {
    private final SimpleQueryTemplateParser parser = new SimpleQueryTemplateParser();

    @Test
    public void detectsSelect() throws Exception {
        String sql = "SELECT * FROM PLANET";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsSelectWithLineBreak() throws Exception {
        String sql = "SELECT *\nFROM PLANET";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsUpdate() throws Exception {
        String sql = "update PLANET set NAME='Mercury' where ID=1";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.UPDATE, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsUpdatewithLineBreak() throws Exception {
        String sql = "update PLANET set NAME='Mercury' \nwhere ID=1";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.UPDATE, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsInsert() throws Exception {
        String sql = "INSERT INTO PLANET(POSITION, NAME) VALUES (777, 'Mercury')";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.INSERT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsInsertWithLineBreak() throws Exception {
        String sql = "INSERT INTO PLANET(\nPOSITION, NAME) VALUES (777, 'Mercury')";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.INSERT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsDelete() throws Exception {
        String sql = "delete from PLANET";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.DELETE, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsDeleteWithLineBreak() throws Exception {
        String sql = "delete from PLANET";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.DELETE, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsStoredProcedureWithBrackets() throws Exception {
        this.doStoredProcedureParsingTest("{ call getTestRecords() }");
    }

    @Test
    public void detectsStoredProcedureWithOutBrackets() throws Exception {
        this.doStoredProcedureParsingTest("call getTestRecords()");
    }

    @Test
    public void detectsStoredProcedureWithSpaces() throws Exception {
        this.doStoredProcedureParsingTest("  {  call  getTestRecords()  } ");
    }

    @Test
    public void detectsStoredProcedureWithLineBreak() throws Exception {
        this.doStoredProcedureParsingTest("{ call \ngetTestRecords() } ");
    }

    private void doStoredProcedureParsingTest(String sql) {
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.STORE_PROCEDURE_CALL, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql.trim(), (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void parsesQuestionMarkParam() throws Exception {
        String sql = "SELECT * FROM PLANET WHERE POSITION = ?";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
    }

    @Test
    public void parsesNamedParam() throws Exception {
        QueryTemplate queryTemplate = this.parser.parse("update PLANET set NAME='Mercury' where ID= :planetId");
        Assert.assertEquals((Object)QueryType.UPDATE, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"update PLANET set NAME='Mercury' where ID= ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"planetId", (Object)param1.getName());
        Assert.assertNull((Object)param1.getValue());
    }

    @Test
    public void definesTemplateWithExpressionParam() throws Exception {
        QueryTemplate queryTemplate = this.parser.parse("update PLANET set NAME='Mercury' where ID= #[planetId]");
        Assert.assertEquals((Object)QueryType.UPDATE, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"update PLANET set NAME='Mercury' where ID= ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertNull((Object)param1.getName());
        Assert.assertEquals((Object)"#[planetId]", (Object)param1.getValue());
    }

    @Test
    public void definesTemplateWithComplexExpressionParam() throws Exception {
        QueryTemplate queryTemplate = this.parser.parse("SELECT * FROM PLANET WHERE POSITION = #[message.inboundProperties['position']] AND NAME= #[planetName]");
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = ? AND NAME= ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)2L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertNull((Object)param1.getName());
        Assert.assertEquals((Object)"#[message.inboundProperties['position']]", (Object)param1.getValue());
        InputQueryParam param2 = (InputQueryParam)queryTemplate.getInputParams().get(1);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param2.getType());
        Assert.assertNull((Object)param2.getName());
        Assert.assertEquals((Object)"#[planetName]", (Object)param2.getValue());
    }

    @Test
    public void detectsUnterminatedMuleExpression() throws Exception {
        try {
            this.parser.parse("SELECT * FROM PLANET where id = #[incompleteExpression");
            Assert.fail((String)"Did not detect an unfinished mule expression");
        }
        catch (QueryTemplateParsingException e) {
            Assert.assertTrue((String)"Error message did not contains invalid expression", (boolean)e.getMessage().endsWith("#[incompleteExpression"));
        }
    }
}

