/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.executor.QueryExecutor;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.UpdateMessageProcessor;
import org.mule.tck.size.SmallTest;

@Ignore(value="Re-add query validation")
@SmallTest
public class UpdateMessageProcessorTestCase {
    @Test
    public void testAcceptsValidQuery() throws Exception {
    }

    @Test
    public void testRejectsNonSupportedSql() throws Exception {
        DbConnectionFactory dbConnectionFactory = (DbConnectionFactory)Mockito.mock(DbConnectionFactory.class);
        for (QueryType type : QueryType.values()) {
            QueryTemplate queryTemplate = new QueryTemplate("UNUSED SQL TEXT", type, Collections.emptyList());
            if (type == QueryType.UPDATE || type == QueryType.STORE_PROCEDURE_CALL) continue;
            try {
                Query query = new Query(queryTemplate, null);
                new UpdateMessageProcessor(null, null, null, null, null);
                Assert.fail((String)"UpdateMessageProcessor should accept UPDATE query only");
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCommitsWorkIfNoTransactionDefined() throws Exception {
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        DbConnectionFactory dbConnectionFactory = (DbConnectionFactory)Mockito.mock(DbConnectionFactory.class);
        Mockito.when((Object)dbConnectionFactory.createConnection(TransactionalAction.JOIN_IF_POSSIBLE)).thenReturn((Object)connection);
        QueryExecutor updateExecutor = (QueryExecutor)Mockito.mock(QueryExecutor.class);
        UpdateMessageProcessor processor = new UpdateMessageProcessor(null, null, null, null, null);
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage muleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)muleMessage);
        processor.process(event);
        ((DbConnectionFactory)Mockito.verify((Object)dbConnectionFactory, (VerificationMode)Mockito.times((int)1))).releaseConnection(connection);
        ((QueryExecutor)Mockito.verify((Object)updateExecutor, (VerificationMode)Mockito.times((int)1))).execute((DbConnection)Matchers.eq((Object)connection), (Query)Matchers.any(Query.class), (AutoGeneratedKeyStrategy)Matchers.any(NoAutoGeneratedKeyStrategy.class));
    }
}

