/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.param;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.resolver.param.QueryParamTypeResolver;
import org.mule.module.db.test.util.DbConnectionBuilder;
import org.mule.module.db.test.util.DbTypeManagerBuilder;
import org.mule.module.db.test.util.ParameterMetaDataBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class QueryParamTypeResolverTestCase
extends AbstractMuleTestCase {
    @Test
    public void resolvesQueryParameterTypes() throws Exception {
        String sqlText = "select * from test where id = ?";
        ParameterMetaData parameterMetaData = new ParameterMetaDataBuilder().withParameter(1, JdbcTypes.INTEGER_DB_TYPE).build();
        PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)preparedStatement.getParameterMetaData()).thenReturn((Object)parameterMetaData);
        DbConnection connection = new DbConnectionBuilder().preparing("select * from test where id = ?", preparedStatement).build();
        QueryTemplate queryTemplate = new QueryTemplate("select * from test where id = ?", QueryType.SELECT, Collections.singletonList(new DefaultInputQueryParam(1, UnknownDbType.getInstance(), (Object)"7", "param1")));
        DbTypeManager dbTypeManager = new DbTypeManagerBuilder().on(connection).managing(JdbcTypes.INTEGER_DB_TYPE).build();
        QueryParamTypeResolver paramTypeResolver = new QueryParamTypeResolver(dbTypeManager);
        Map parameterTypes = paramTypeResolver.getParameterTypes(connection, queryTemplate);
        Assert.assertThat((Object)parameterTypes.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat(parameterTypes.get(1), (Matcher)CoreMatchers.equalTo((Object)JdbcTypes.INTEGER_DB_TYPE));
    }
}

