/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import java.util.ArrayList;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class AbstractQueryResolverTestCase
extends AbstractMuleTestCase {
    public static final String STATIC_SQL_TEXT = "select * from test";
    public static final String DYNAMIC_SQL_TEXT = "select * from #[table]";
    protected final MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);

    protected Query createQuery(QueryTemplate template, Object[] paramValues) {
        ArrayList<QueryParamValue> queryParamValues = new ArrayList<QueryParamValue>();
        if (paramValues != null) {
            int paramIndex = 1;
            for (Object param : paramValues) {
                QueryParamValue paramValue = new QueryParamValue("param" + paramIndex++, param);
                queryParamValues.add(paramValue);
            }
        }
        return new Query(template, queryParamValues);
    }

    protected Query createQuery(QueryTemplate template) {
        return new Query(template);
    }

    protected QueryTemplate createQueryTemplate(String staticSqlText) {
        return this.createQueryTemplate(staticSqlText, new DbType[0]);
    }

    protected QueryTemplate createQueryTemplate(String staticSqlText, DbType[] paramTypes) {
        ArrayList<DefaultInputQueryParam> queryParams = new ArrayList<DefaultInputQueryParam>(paramTypes.length);
        int index = 1;
        for (DbType paramType : paramTypes) {
            DefaultInputQueryParam inputQueryParam = new DefaultInputQueryParam(index, paramType, (Object)("param" + index));
            queryParams.add(inputQueryParam);
            ++index;
        }
        return new QueryTemplate(staticSqlText, QueryType.SELECT, queryParams);
    }
}

