/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.query.BulkQuery;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.mule.module.db.internal.resolver.query.AbstractBulkQueryResolverTestCase;
import org.mule.module.db.internal.resolver.query.FileBulkQueryResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.module.db.internal.util.FileReader;
import org.mule.tck.size.SmallTest;

@SmallTest
public class FileBulkQueryResolverTestCase
extends AbstractBulkQueryResolverTestCase {
    @Test
    public void doesNotResolvesBulkQueryWhenThereIsNoEvent() throws Exception {
        FileBulkQueryResolver bulkQueryResolver = new FileBulkQueryResolver(null, null, null);
        BulkQuery resolvedBulkQuery = bulkQueryResolver.resolve(null);
        Assert.assertThat((Object)resolvedBulkQuery, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void resolvesBulkQuery() throws Exception {
        String fileName = "fileName";
        QueryTemplateParser queryTemplateParser = this.createQueryTemplateParser();
        FileReader fileReader = (FileReader)Mockito.mock(FileReader.class);
        Mockito.when((Object)fileReader.getResourceAsString(fileName)).thenReturn((Object)"delete from test1;\ndelete from test2");
        FileBulkQueryResolver bulkQueryResolver = new FileBulkQueryResolver(fileName, queryTemplateParser, fileReader);
        BulkQuery resolvedBulkQuery = bulkQueryResolver.resolve(this.muleEvent);
        this.assertResolvedBulkQuery(resolvedBulkQuery);
    }

    @Test(expected=QueryResolutionException.class)
    public void throwsErrorOnEmptyBulkQuery() throws Exception {
        String fileName = "fileName";
        FileReader fileReader = (FileReader)Mockito.mock(FileReader.class);
        Mockito.when((Object)fileReader.getResourceAsString(fileName)).thenReturn((Object)"");
        FileBulkQueryResolver bulkQueryResolver = new FileBulkQueryResolver(fileName, null, fileReader);
        bulkQueryResolver.resolve(this.muleEvent);
    }

    @Test(expected=QueryResolutionException.class)
    public void throwsErrorOnFileReadError() throws Exception {
        String fileName = "fileName";
        FileReader fileReader = (FileReader)Mockito.mock(FileReader.class);
        Mockito.when((Object)fileReader.getResourceAsString(fileName)).thenThrow(new Throwable[]{new IOException("Error")});
        FileBulkQueryResolver bulkQueryResolver = new FileBulkQueryResolver(fileName, null, fileReader);
        bulkQueryResolver.resolve(this.muleEvent);
    }
}

