/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.delete;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.common.Result;
import org.mule.construct.Flow;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.delete.AbstractBulkUpdateInputMetadataTestCase;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.processor.AbstractDbMessageProcessor;

public class DeleteBulkInputMetadataTestCase
extends AbstractBulkUpdateInputMetadataTestCase {
    public DeleteBulkInputMetadataTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/delete/delete-bulk-input-metadata-config.xml"};
    }

    @Test
    public void returnsNullDeleteMetadataUnParameterizedQuery() throws Exception {
        this.doUnresolvedMetadataTest("deleteBulkMetadataNoParams");
    }

    @Test
    public void returnsNullDeleteInputMetadataFromNotSupportedParameterizedQuery() throws Exception {
        this.doUnresolvedMetadataTest("deleteBulkMetadataNotSupportedValueParams");
    }

    @Test
    public void returnsDeleteInputMetadataFromBeanParameterizedQuery() throws Exception {
        this.doResolvedMetadataTest("deleteBulkMetadataBeanParams");
    }

    @Test
    public void returnsDeleteInputMetadataFromMapParameterizedQuery() throws Exception {
        this.doResolvedMetadataTest("deleteBulkMetadataMapParams");
    }

    private void doUnresolvedMetadataTest(String flowName) {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct(flowName);
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractDbMessageProcessor messageProcessor = (AbstractDbMessageProcessor)messageProcessors.get(0);
        Result inputMetaData = messageProcessor.getInputMetaData();
        Assert.assertThat((Object)inputMetaData, (Matcher)CoreMatchers.equalTo(null));
    }
}

