/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.model;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mule.module.db.integration.model.AbstractTestDatabase;

public class DerbyTestDatabase
extends AbstractTestDatabase {
    public static final String DERBY_ERROR_OBJECT_ALREADY_EXISTS = "X0Y68";
    public static String SQL_CREATE_SP_UPDATE_TEST_TYPE_1 = "CREATE PROCEDURE updateTestType1()\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nMODIFIES SQL DATA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME 'org.mule.module.db.integration.model.derbyutil.DerbyTestStoredProcedure.updateTestType1'";
    public static String SQL_CREATE_SP_PARAM_UPDATE_TEST_TYPE_1 = "CREATE PROCEDURE updateParamTestType1(name VARCHAR(40))\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nMODIFIES SQL DATA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME 'org.mule.module.db.integration.model.derbyutil.DerbyTestStoredProcedure.updateParameterizedTestType1'";
    public static String SQL_CREATE_SP_COUNT_RECORDS = "CREATE PROCEDURE countTestRecords(OUT COUNT INTEGER)\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nREADS SQL DATA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME 'org.mule.module.db.integration.model.derbyutil.DerbyTestStoredProcedure.countTestRecords'";
    public static String SQL_CREATE_SP_GET_RECORDS = "CREATE PROCEDURE getTestRecords()\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nREADS SQL DATA\nDYNAMIC RESULT SETS 1\nEXTERNAL NAME 'org.mule.module.db.integration.model.derbyutil.DerbyTestStoredProcedure.getTestRecords'";
    public static String SQL_CREATE_SP_GET_SPLIT_RECORDS = "CREATE PROCEDURE getSplitTestRecords()\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nREADS SQL DATA\nDYNAMIC RESULT SETS 2\nEXTERNAL NAME 'org.mule.module.db.integration.model.derbyutil.DerbyTestStoredProcedure.getSplitTestRecords'";
    public static String SQL_CREATE_SP_DOUBLE_MY_INT = "CREATE PROCEDURE doubleMyInt(INOUT MYINT INTEGER)\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME 'org.mule.module.db.integration.model.derbyutil.DerbyTestStoredProcedure.doubleMyInt'";
    public static String SQL_CREATE_SP_MULTIPLY_INTS = "CREATE PROCEDURE multiplyInts(IN INT1 INTEGER, IN INT2 INTEGER, OUT RESULT INTEGER)\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME 'org.mule.module.db.integration.model.derbyutil.DerbyTestStoredProcedure.multiplyInts'";
    public static String SQL_CREATE_SP_CONCATENATE_STRINGS = "CREATE PROCEDURE concatenateStrings(IN INT1 VARCHAR(100), IN INT2 VARCHAR(100), OUT RESULT VARCHAR(200))\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME 'org.mule.module.db.integration.model.derbyutil.DerbyTestStoredProcedure.concatenateStrings'";

    @Override
    public void createPlanetTable(Connection connection) throws SQLException {
        DerbyTestDatabase.executeDdl(connection, "CREATE TABLE PLANET(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0)  NOT NULL PRIMARY KEY,POSITION INTEGER,NAME VARCHAR(255))");
    }

    @Override
    protected String getInsertPlanetSql(String name, int position) {
        return "INSERT INTO PLANET(POSITION, NAME) VALUES (" + position + ", '" + name + "')";
    }

    @Override
    public void createStoredProcedureUpdateTestType1(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_UPDATE_TEST_TYPE_1);
    }

    @Override
    public void createStoredProcedureParameterizedUpdateTestType1(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_PARAM_UPDATE_TEST_TYPE_1);
    }

    @Override
    public void createStoredProcedureCountRecords(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_COUNT_RECORDS);
    }

    @Override
    public void createStoredProcedureGetRecords(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_GET_RECORDS);
    }

    @Override
    public void createStoredProcedureGetSplitRecords(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_GET_SPLIT_RECORDS);
    }

    @Override
    public void createStoredProcedureDoubleMyInt(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_DOUBLE_MY_INT);
    }

    @Override
    public void createStoredProcedureMultiplyInts(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_MULTIPLY_INTS);
    }

    @Override
    public void createStoredProcedureConcatenateStrings(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_CONCATENATE_STRINGS);
    }

    @Override
    public void createStoredProcedure(DataSource dataSource, String sql) throws SQLException {
        block2: {
            try {
                super.createStoredProcedure(dataSource, sql);
            }
            catch (SQLException e) {
                if (DERBY_ERROR_OBJECT_ALREADY_EXISTS.equals(e.getSQLState())) break block2;
                throw e;
            }
        }
    }
}

