/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.model;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mule.common.metadata.datatype.DataType;
import org.mule.module.db.integration.model.AbstractTestDatabase;

public class MySqlTestDatabase
extends AbstractTestDatabase {
    public static String SQL_CREATE_SP_UPDATE_TEST_TYPE_1 = "CREATE DEFINER=CURRENT_USER PROCEDURE updateTestType1()\nBEGIN\n    UPDATE PLANET SET NAME='Mercury' WHERE POSITION=4;\nEND;";
    public static String SQL_CREATE_SP_GET_RECORDS = "CREATE DEFINER=CURRENT_USER PROCEDURE getTestRecords()\nBEGIN\n    SELECT * FROM PLANET;\nEND;";
    public static String SQL_CREATE_SP_GET_SPLIT_RECORDS = "CREATE DEFINER=CURRENT_USER PROCEDURE getSplitTestRecords()\nBEGIN\n    SELECT * FROM PLANET WHERE POSITION <= 2;\n    SELECT * FROM PLANET WHERE POSITION > 2;\nEND;";

    @Override
    public void createPlanetTable(Connection connection) throws SQLException {
        MySqlTestDatabase.executeDdl(connection, "CREATE TABLE PLANET(ID INTEGER NOT NULL AUTO_INCREMENT,POSITION INTEGER,NAME VARCHAR(255), PRIMARY KEY (ID))");
    }

    @Override
    protected String getInsertPlanetSql(String name, int position) {
        return "INSERT INTO PLANET(POSITION, NAME) VALUES (" + position + ", '" + name + "')";
    }

    @Override
    public void createStoredProcedureGetRecords(DataSource dataSource) throws SQLException {
        MySqlTestDatabase.executeDdl(dataSource, "DROP PROCEDURE IF EXISTS getTestRecords;\n");
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_GET_RECORDS);
    }

    @Override
    public void createStoredProcedureUpdateTestType1(DataSource dataSource) throws SQLException {
        MySqlTestDatabase.executeDdl(dataSource, "DROP PROCEDURE IF EXISTS updateTestType1;\n");
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_UPDATE_TEST_TYPE_1);
    }

    @Override
    public void createStoredProcedureParameterizedUpdateTestType1(DataSource dataSource) throws SQLException {
        MySqlTestDatabase.executeDdl(dataSource, "DROP PROCEDURE IF EXISTS updateParamTestType1;\n");
        String sql = "CREATE DEFINER=CURRENT_USER PROCEDURE updateParamTestType1(IN pName VARCHAR(50))\nBEGIN\nUPDATE PLANET SET NAME=pName WHERE POSITION=4;\nEND";
        this.createStoredProcedure(dataSource, "CREATE DEFINER=CURRENT_USER PROCEDURE updateParamTestType1(IN pName VARCHAR(50))\nBEGIN\nUPDATE PLANET SET NAME=pName WHERE POSITION=4;\nEND");
    }

    @Override
    public void createStoredProcedureCountRecords(DataSource dataSource) throws SQLException {
        MySqlTestDatabase.executeDdl(dataSource, "DROP PROCEDURE IF EXISTS countTestRecords;\n");
        String sql = "CREATE DEFINER=CURRENT_USER PROCEDURE countTestRecords(OUT pResult INT)\nBEGIN\nselect count(*) into pResult from Planet;\nEND";
        this.createStoredProcedure(dataSource, "CREATE DEFINER=CURRENT_USER PROCEDURE countTestRecords(OUT pResult INT)\nBEGIN\nselect count(*) into pResult from Planet;\nEND");
    }

    @Override
    public void createStoredProcedureGetSplitRecords(DataSource dataSource) throws SQLException {
        MySqlTestDatabase.executeDdl(dataSource, "DROP PROCEDURE IF EXISTS getSplitTestRecords;\n");
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_GET_SPLIT_RECORDS);
    }

    @Override
    public void createStoredProcedureDoubleMyInt(DataSource dataSource) throws SQLException {
        MySqlTestDatabase.executeDdl(dataSource, "DROP PROCEDURE IF EXISTS doubleMyInt;\n");
        String sql = "CREATE DEFINER=CURRENT_USER PROCEDURE doubleMyInt(INOUT pInt INT)\nBEGIN\nSET pInt := pInt * 2;\nEND";
        this.createStoredProcedure(dataSource, "CREATE DEFINER=CURRENT_USER PROCEDURE doubleMyInt(INOUT pInt INT)\nBEGIN\nSET pInt := pInt * 2;\nEND");
    }

    @Override
    public void createStoredProcedureMultiplyInts(DataSource dataSource) throws SQLException {
        MySqlTestDatabase.executeDdl(dataSource, "DROP PROCEDURE IF EXISTS multiplyInts;\n");
        String sql = "CREATE DEFINER=CURRENT_USER PROCEDURE multiplyInts(IN pInt1 INT, IN iInt2 INT, OUT pResult INT)\nBEGIN\nSET pResult := pInt1 * iInt2;\nEND";
        this.createStoredProcedure(dataSource, "CREATE DEFINER=CURRENT_USER PROCEDURE multiplyInts(IN pInt1 INT, IN iInt2 INT, OUT pResult INT)\nBEGIN\nSET pResult := pInt1 * iInt2;\nEND");
    }

    @Override
    public void createStoredProcedureConcatenateStrings(DataSource dataSource) throws SQLException {
        MySqlTestDatabase.executeDdl(dataSource, "DROP PROCEDURE IF EXISTS concatenateStrings;\n");
        String sql = "CREATE DEFINER=CURRENT_USER PROCEDURE concatenateStrings(IN pString1 VARCHAR(50), IN pString2 VARCHAR(50), OUT pResult VARCHAR(100))\nBEGIN\nSET pResult := CONCAT(pString1, pString2);\nEND";
        this.createStoredProcedure(dataSource, "CREATE DEFINER=CURRENT_USER PROCEDURE concatenateStrings(IN pString1 VARCHAR(50), IN pString2 VARCHAR(50), OUT pResult VARCHAR(100))\nBEGIN\nSET pResult := CONCAT(pString1, pString2);\nEND");
    }

    @Override
    public DataType getIdFieldInputMetaDataType() {
        return DataType.STRING;
    }
}

