/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.DerbyTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;

public abstract class AbstractStoredProcedureUpdateTestCase
extends AbstractDbIntegrationTestCase {
    public AbstractStoredProcedureUpdateTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Test
    public void testRequestResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testRequestResponse", (Object)"Test Message", null);
        Assert.assertThat((Object)response.getPayload(), (Matcher)Is.is(Map.class));
        Map mapPayload = (Map)response.getPayload();
        int expectedUpdateCount = this.testDatabase instanceof DerbyTestDatabase ? 0 : 1;
        Assert.assertThat((Object)((Integer)mapPayload.get("updateCount1")), (Matcher)CoreMatchers.equalTo((Object)expectedUpdateCount));
        List<Map<String, String>> result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        this.testDatabase.createStoredProcedureUpdateTestType1(this.getDefaultDataSource());
    }
}

