/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.database;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.config.domain.database.MySqlConfigFactoryBean;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MysqlConfigFactoryBeanTestCase
extends AbstractMuleTestCase {
    private static final String URL = "jdbc:mysql://localhost:3036/database";
    private static final String URL_WITHOUT_PORT = "jdbc:mysql://localhost/database";
    private static final String URL_PROPERTIES = "?user=root&password=pass";
    private static final String METADATA_PROPERTY = "generateSimpleParameterMetadata=true";
    private static final String DATABASE = "database";
    private static final String HOST = "localhost";
    private static final int PORT = 3036;
    private static final String USER_PROPERTY = "user";
    private static final String USER_VALUE = "root";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String PASSWORD_VALUE = "pass";
    private MySqlConfigFactoryBean factory;
    private Map<String, String> properties;

    @Before
    public void setUp() throws Exception {
        this.factory = new MySqlConfigFactoryBean();
        this.properties = new LinkedHashMap<String, String>();
        this.factory.setConnectionProperties(this.properties);
    }

    @Test
    public void staticUrlWithoutProperties() {
        this.factory.setUrl(URL);
        Assert.assertEquals((String)URL, (String)this.factory.getEffectiveUrl());
    }

    @Test
    public void dynamicUrlWithoutProperties() {
        this.factory.setDatabase(DATABASE);
        this.factory.setHost(HOST);
        this.factory.setPort(3036);
        Assert.assertEquals((String)URL, (String)this.factory.getEffectiveUrl());
    }

    @Test
    public void dynamicUrlWithoutPropertiesAndPort() {
        this.factory.setDatabase(DATABASE);
        this.factory.setHost(HOST);
        Assert.assertEquals((String)URL_WITHOUT_PORT, (String)this.factory.getEffectiveUrl());
    }

    @Test
    public void staticUrlWithProperties() {
        this.factory.setUrl(URL);
        this.properties.put(USER_PROPERTY, USER_VALUE);
        this.properties.put(PASSWORD_PROPERTY, PASSWORD_VALUE);
        Assert.assertEquals((String)"jdbc:mysql://localhost:3036/database?user=root&password=pass", (String)this.factory.getEffectiveUrl());
    }

    @Test
    public void dynamicUrlWithProperties() {
        this.factory.setDatabase(DATABASE);
        this.factory.setHost(HOST);
        this.factory.setPort(3036);
        this.properties.put(USER_PROPERTY, USER_VALUE);
        this.properties.put(PASSWORD_PROPERTY, PASSWORD_VALUE);
        Assert.assertEquals((String)"jdbc:mysql://localhost:3036/database?user=root&password=pass", (String)this.factory.getEffectiveUrl());
    }

    @Test
    public void dynamicUrlWithPropertiesWithoutPort() {
        this.factory.setDatabase(DATABASE);
        this.factory.setHost(HOST);
        this.properties.put(USER_PROPERTY, USER_VALUE);
        this.properties.put(PASSWORD_PROPERTY, PASSWORD_VALUE);
        Assert.assertEquals((String)"jdbc:mysql://localhost/database?user=root&password=pass", (String)this.factory.getEffectiveUrl());
    }

    @Test
    public void validateNoDatasourceNorProperties() throws Exception {
        this.factory.validate();
    }

    @Test
    public void validateDatasourceWithoutProperties() throws Exception {
        this.factory.setDataSource((DataSource)Mockito.mock(DataSource.class));
        this.factory.validate();
    }

    @Test(expected=IllegalStateException.class)
    public void validateDatasourceWithProperties() throws Exception {
        this.factory.setDataSource((DataSource)Mockito.mock(DataSource.class));
        this.properties.put(USER_PROPERTY, USER_VALUE);
        this.factory.validate();
    }
}

