/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.module.db.internal.domain.query.BulkQuery;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class AbstractBulkQueryResolverTestCase
extends AbstractMuleTestCase {
    public static final String STATIC_SQL_1 = "delete from test1";
    public static final String STATIC_SQL_2 = "delete from test2";
    public static final String BULK_SQL_QUERY = "delete from test1;\ndelete from test2";
    protected final MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);

    protected QueryTemplateParser createQueryTemplateParser() {
        QueryTemplateParser queryTemplateParser = (QueryTemplateParser)Mockito.mock(QueryTemplateParser.class);
        Mockito.when((Object)queryTemplateParser.parse(STATIC_SQL_1)).thenReturn((Object)new QueryTemplate(STATIC_SQL_1, QueryType.DELETE, Collections.emptyList()));
        Mockito.when((Object)queryTemplateParser.parse(STATIC_SQL_2)).thenReturn((Object)new QueryTemplate(STATIC_SQL_2, QueryType.DELETE, Collections.emptyList()));
        return queryTemplateParser;
    }

    protected void assertResolvedBulkQuery(BulkQuery resolvedBulkQuery) {
        Assert.assertThat((Object)resolvedBulkQuery.getQueryTemplates().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((QueryTemplate)resolvedBulkQuery.getQueryTemplates().get(0)).getSqlText(), (Matcher)CoreMatchers.equalTo((Object)STATIC_SQL_1));
        Assert.assertThat((Object)((QueryTemplate)resolvedBulkQuery.getQueryTemplates().get(1)).getSqlText(), (Matcher)CoreMatchers.equalTo((Object)STATIC_SQL_2));
    }
}

