/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.performance;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.db.performance.LoadTask;

public class LoadGenerator {
    public static final int DEFAULT_THREADS = 20;
    public static final int DEFAULT_MESSAGE_PER_THREAD = 200;
    public static final int DEFAULT_MESSAGE_DELAY = 50;
    protected static final Log logger = LogFactory.getLog(LoadGenerator.class);
    private final int threadCount;
    private final int messagesPerThread;
    private final int messageDelay;

    public LoadGenerator() {
        this(20, 200, 50);
    }

    public LoadGenerator(int threadCount, int messagesPerThread, int messageDelay) {
        this.threadCount = threadCount;
        this.messagesPerThread = messagesPerThread;
        this.messageDelay = messageDelay;
    }

    /*
     * WARNING - void declaration
     */
    public void generateLoad(final LoadTask loadTask) throws InterruptedException, ExecutionException {
        void var6_9;
        ArrayList<1> solvers = new ArrayList<1>(this.getThreadCount());
        for (int i = 1; i <= this.getThreadCount(); ++i) {
            solvers.add(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    for (int message = 1; message <= LoadGenerator.this.getMessagesPerThread(); ++message) {
                        try {
                            loadTask.execute(message);
                        }
                        catch (Exception e) {
                            logger.error((Object)("Error sending message: " + e.getMessage()));
                        }
                        Thread.sleep(LoadGenerator.this.getMessageDelay());
                    }
                    return LoadGenerator.this.getMessagesPerThread();
                }
            });
        }
        ExecutorService exec = Executors.newFixedThreadPool(this.getThreadCount());
        ExecutorCompletionService executorCompletionService = new ExecutorCompletionService(exec);
        for (Callable callable : solvers) {
            executorCompletionService.submit(callable);
        }
        Integer count = 0;
        boolean bl = false;
        while (var6_9 < this.getThreadCount()) {
            count = count + (Integer)executorCompletionService.take().get();
            logger.info((Object)("Current row processed count: " + count));
            ++var6_9;
        }
        logger.info((Object)"Load generation completed");
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getMessagesPerThread() {
        return this.messagesPerThread;
    }

    public int getMessageDelay() {
        return this.messageDelay;
    }
}

