/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sql.executor;

import java.sql.Statement;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.UpdateExecutor;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.statement.StatementFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class UpdateTestCase
extends AbstractMuleTestCase {
    @Test
    public void testUpdate() throws Exception {
        Statement statement = (Statement)Mockito.mock(Statement.class);
        String sqlText = "UPDATE dummy SET NAME='Mercury' WHERE id=777";
        Mockito.when((Object)statement.executeUpdate(sqlText, 2)).thenReturn((Object)1);
        StatementFactory statementFactory = (StatementFactory)Mockito.mock(StatementFactory.class);
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        UpdateExecutor updateExecutor = new UpdateExecutor(statementFactory);
        QueryTemplate queryTemplate = new QueryTemplate(sqlText, QueryType.UPDATE, Collections.emptyList());
        Mockito.when((Object)statementFactory.create(connection, queryTemplate)).thenReturn((Object)statement);
        Query query = new Query(queryTemplate, null);
        Object result = updateExecutor.execute(connection, query);
        Assert.assertEquals((Object)1, (Object)result);
    }
}

