/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.executor;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.db.internal.domain.logger.DefaultQueryLoggerFactory;
import org.mule.module.db.internal.domain.logger.QueryLoggerFactory;
import org.mule.module.db.internal.domain.logger.SingleQueryLogger;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.param.OutputQueryParam;
import org.mule.module.db.internal.domain.param.QueryParam;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.statement.StatementFactory;
import org.mule.module.db.internal.domain.type.DbType;

public abstract class AbstractExecutor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final StatementFactory statementFactory;
    protected QueryLoggerFactory queryLoggerFactory = new DefaultQueryLoggerFactory();

    public AbstractExecutor(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    protected void doProcessParameters(PreparedStatement statement, QueryTemplate queryTemplate, List<QueryParamValue> paramValues, SingleQueryLogger queryLogger) throws SQLException {
        int inputParamsSize = queryTemplate.getParams().size();
        for (int index = 1; index <= inputParamsSize; ++index) {
            QueryParam queryParam = queryTemplate.getParams().get(index - 1);
            if (queryParam instanceof InputQueryParam) {
                QueryParamValue param = paramValues.get(index - 1);
                queryLogger.addParameter(queryTemplate.getInputParams().get(index - 1), param.getValue());
                this.processInputParam(statement, index, param.getValue(), queryParam.getType());
            }
            if (!(queryParam instanceof OutputQueryParam)) continue;
            this.processOutputParam((CallableStatement)statement, index, queryParam.getType());
        }
    }

    protected void processInputParam(PreparedStatement statement, int index, Object value, DbType type) throws SQLException {
        type.setParameterValue(statement, index, value);
    }

    private void processOutputParam(CallableStatement statement, int index, DbType type) throws SQLException {
        type.registerOutParameter(statement, index);
    }

    public void setQueryLoggerFactory(QueryLoggerFactory queryLoggerFactory) {
        this.queryLoggerFactory = queryLoggerFactory;
    }
}

