/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.result.statement;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.result.resultset.ResultSetHandler;
import org.mule.module.db.internal.result.statement.StatementResult;
import org.mule.module.db.internal.result.statement.StatementResultHandler;
import org.mule.module.db.internal.result.statement.StatementResultIterator;
import org.mule.module.db.internal.result.statement.StatementResultIteratorFactory;

public abstract class AbstractMapStatementResultHandler
implements StatementResultHandler {
    private final ResultSetHandler resultSetHandler;

    public AbstractMapStatementResultHandler(ResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    @Override
    public Object processStatement(DbConnection connection, Statement statement, QueryTemplate queryTemplate, AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) throws SQLException {
        Map<String, Object> result = this.createResultMap();
        StatementResultIteratorFactory statementResultIteratorFactory = connection.getStatementResultIteratorFactory(this.resultSetHandler);
        StatementResultIterator statementResultIterator = statementResultIteratorFactory.create(connection, statement, queryTemplate, autoGeneratedKeyStrategy);
        while (statementResultIterator.hasNext()) {
            StatementResult next = statementResultIterator.next();
            result.put(next.getName(), next.getResult());
        }
        return result;
    }

    protected abstract Map<String, Object> createResultMap();
}

