/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.result.statement;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.Closeable;
import org.mule.api.MuleException;

public class CloseableMap<K, V>
implements Map<K, V>,
Closeable {
    protected static final Log logger = LogFactory.getLog(CloseableMap.class);
    private Map<K, V> delegate = new HashMap();

    public void close() throws MuleException {
        for (V value : this.delegate.values()) {
            if (!(value instanceof Closeable)) continue;
            try {
                ((Closeable)value).close();
            }
            catch (MuleException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Error closing map element", (Throwable)e);
            }
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.delegate.putAll(map);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }
}

