/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.config;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;

public class DatasourcePoolingLimitTestCase
extends AbstractDbIntegrationTestCase {
    public DatasourcePoolingLimitTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/config/derby-minimum-pooling-db-config.xml", "integration/config/connection-pooling-config.xml"};
    }

    @Test
    public void limitsConnections() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testIn", (Object)"Test Message", null);
        Assert.assertTrue((boolean)(response.getExceptionPayload().getException() instanceof MessagingException));
        MessagingException exception = (MessagingException)response.getExceptionPayload().getException();
        Assert.assertTrue((boolean)exception.getMessage().contains("An attempt by a client to checkout a Connection has timed out"));
    }
}

