/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.common.metadata.datatype.DataType;
import org.mule.module.db.integration.model.Alien;
import org.mule.module.db.integration.model.Planet;

public abstract class AbstractTestDatabase {
    public static final Planet[] PLANET_TEST_VALUES = new Planet[]{Planet.VENUS, Planet.EARTH, Planet.MARS};
    public static final Alien[] ALIEN_TEST_VALUES = new Alien[]{Alien.MONGUITO, Alien.ET};
    private static final Log logger = LogFactory.getLog(AbstractTestDatabase.class);
    public static final String NO_SQLXML_SUPPORT_ERROR = "Database does not support SQLXML type";

    public void deletePlanetTable(Connection connection) throws SQLException {
        this.executeUpdate(connection, "DELETE FROM PLANET");
    }

    public abstract void createPlanetTable(Connection var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeDdl(DataSource dataSource, String ddl) throws SQLException {
        Connection connection = dataSource.getConnection();
        try {
            AbstractTestDatabase.executeDdl(connection, ddl);
        }
        finally {
            connection.close();
        }
    }

    public static void executeDdl(Connection connection, String ddl) throws SQLException {
        QueryRunner qr = new QueryRunner();
        qr.update(connection, ddl);
    }

    public void executeUpdate(Connection connection, String updateSql) throws SQLException {
        QueryRunner qr = new QueryRunner();
        int updated = qr.update(connection, updateSql);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(updated + " rows updated"));
        }
    }

    public final void populatePlanetTable(Connection connection, Planet[] testValues) throws SQLException {
        QueryRunner qr = new QueryRunner();
        for (Planet planet : testValues) {
            int updated = qr.update(connection, this.getInsertPlanetSql(planet.getName(), planet.getPosition()));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(updated + " rows updated"));
        }
    }

    protected abstract String getInsertPlanetSql(String var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultDatabaseConfig(DataSource dataSource) throws SQLException {
        Connection connection = dataSource.getConnection();
        try {
            connection.setAutoCommit(false);
            this.createPlanetTestTable(connection);
            if (this.supportsXmlType()) {
                this.createAlienTestTable(connection);
            }
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void createAlienTestTable(Connection connection) throws SQLException {
        try {
            this.deleteAlienTable(connection);
        }
        catch (Exception e) {
            this.createAlienTable(connection);
        }
        this.populateAlienTable(connection, ALIEN_TEST_VALUES);
    }

    private void populateAlienTable(Connection connection, Alien[] testValues) throws SQLException {
        QueryRunner qr = new QueryRunner();
        for (Alien alien : testValues) {
            int updated = qr.update(connection, this.getInsertAlienSql(alien));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(updated + " rows updated"));
        }
    }

    protected void createAlienTable(Connection connection) throws SQLException {
        throw new UnsupportedOperationException(NO_SQLXML_SUPPORT_ERROR);
    }

    protected void deleteAlienTable(Connection connection) throws SQLException {
        this.executeUpdate(connection, "DELETE FROM ALIEN");
    }

    protected String getInsertAlienSql(Alien alien) {
        throw new UnsupportedOperationException(NO_SQLXML_SUPPORT_ERROR);
    }

    protected boolean supportsXmlType() {
        return false;
    }

    protected void createPlanetTestTable(Connection connection) throws SQLException {
        try {
            this.deletePlanetTable(connection);
        }
        catch (Exception e) {
            this.createPlanetTable(connection);
        }
        this.populatePlanetTable(connection, PLANET_TEST_VALUES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStoredProcedure(DataSource dataSource, String sql) throws SQLException {
        Connection connection = dataSource.getConnection();
        try {
            Statement statement = connection.createStatement();
            statement.execute(sql);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public abstract void createStoredProcedureGetRecords(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureUpdateTestType1(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureParameterizedUpdateTestType1(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureCountRecords(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureGetSplitRecords(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureDoubleMyInt(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureMultiplyInts(DataSource var1) throws SQLException;

    public abstract void createStoredProcedureConcatenateStrings(DataSource var1) throws SQLException;

    public void createStoredProcedureGetAlienDescription(DataSource dataSource) throws SQLException {
        throw new UnsupportedOperationException(NO_SQLXML_SUPPORT_ERROR);
    }

    public void createStoredProcedureUpdateAlienDescription(DataSource dataSource) throws SQLException {
        throw new UnsupportedOperationException(NO_SQLXML_SUPPORT_ERROR);
    }

    public DataType getIdFieldInputMetaDataType() {
        return DataType.INTEGER;
    }

    public DataType getIdFieldOutputMetaDataType() {
        return DataType.INTEGER;
    }

    public DataType getPositionFieldOutputMetaDataType() {
        return DataType.INTEGER;
    }

    public Class getIdFieldJavaClass() {
        return Number.class;
    }

    public Class getDefaultAutoGeneratedKeyClass() {
        return Number.class;
    }
}

