/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;

public class SelectStreamingChunkTestCase
extends AbstractDbIntegrationTestCase {
    public SelectStreamingChunkTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-streaming-chunk-config.xml"};
    }

    @Test
    public void chunksStreamedRecords() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://selectStreamingChunks", (Object)"Test Message", null);
        List chunks = (List)response.getPayload();
        Assert.assertEquals((long)2L, (long)chunks.size());
        Assert.assertThat(chunks.get(0), (Matcher)Is.is(List.class));
        TestRecordUtil.assertRecords(chunks.get(0), TestRecordUtil.getVenusRecord(), TestRecordUtil.getEarthRecord());
        Assert.assertThat(chunks.get(1), (Matcher)Is.is(List.class));
        TestRecordUtil.assertRecords(chunks.get(1), TestRecordUtil.getMarsRecord());
    }
}

