/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.matcher.SupportsReturningStoredProcedureResultsWithoutParameters;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;

public class StoredProcedureTargetTestCase
extends AbstractDbIntegrationTestCase {
    public StoredProcedureTargetTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/storedprocedure/stored-procedure-target-config.xml"};
    }

    @Test
    public void usesCustomTarget() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://storedProcedureCustomTarget", (Object)"Test Message", null);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
        Assert.assertThat((Object)response.getInboundProperty("statementResult"), (Matcher)CoreMatchers.is(Map.class));
        this.verifyUpdatedRecord();
    }

    private void verifyUpdatedRecord() throws SQLException {
        List<Map<String, String>> result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        Assume.assumeThat((Object)this.getDefaultDataSource(), (Matcher)new SupportsReturningStoredProcedureResultsWithoutParameters());
        this.testDatabase.createStoredProcedureUpdateTestType1(this.getDefaultDataSource());
    }
}

