/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.template;

import org.junit.Assert;
import org.junit.Test;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.tck.junit4.FunctionalTestCase;

public class TemplateQueryConfigTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "integration/template/template-config.xml";
    }

    @Test
    public void definesSelect() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("testSelect");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"position", (Object)param1.getName());
        Assert.assertEquals((Object)"0", (Object)param1.getValue());
    }

    @Test
    public void definesUpdate() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("testUpdate");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertEquals((Object)QueryType.UPDATE, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"update PLANET set NAME='Mercury' where ID=?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"id", (Object)param1.getName());
        Assert.assertEquals((Object)"0", (Object)param1.getValue());
    }

    @Test
    public void readQueryFromFile() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("testFileQuery");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"position", (Object)param1.getName());
        Assert.assertEquals((Object)"1", (Object)param1.getValue());
    }

    @Test
    public void usesDynamicQuery() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("testDynamicQuery");
        Assert.assertTrue((boolean)(queryTemplateBean instanceof QueryTemplate));
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertTrue((boolean)queryTemplate.isDynamic());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = #[position]", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void usesNullDefaultParamValue() throws Exception {
        Object queryTemplateBean = muleContext.getRegistry().get("testNullParamsQuery");
        QueryTemplate queryTemplate = (QueryTemplate)queryTemplateBean;
        Assert.assertFalse((boolean)queryTemplate.isDynamic());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"position", (Object)param1.getName());
        Assert.assertEquals(null, (Object)param1.getValue());
    }
}

