/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.executor.SelectExecutor;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.SelectMessageProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@Ignore(value="Re-add query validation")
@SmallTest
public class SelectMessageProcessorTestCase
extends AbstractMuleTestCase {
    @Test
    public void testAcceptsValidQuery() throws Exception {
    }

    @Test
    public void testRejectsNonSupportedSql() throws Exception {
        DbConnectionFactory dbConnectionFactory = (DbConnectionFactory)Mockito.mock(DbConnectionFactory.class);
        for (QueryType type : QueryType.values()) {
            QueryTemplate queryTemplate = new QueryTemplate("UNUSED SQL TEXT", type, Collections.emptyList());
            if (type == QueryType.SELECT || type == QueryType.STORE_PROCEDURE_CALL) continue;
            try {
                Query query = new Query(queryTemplate, null);
                new SelectMessageProcessor(null, null, null, null, false);
                Assert.fail((String)"SelectMessageProcessor should accept SELECT and DYNAMIC queries only");
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCommitsWorkIfNoTransactionDefined() throws Exception {
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        DbConnectionFactory dbConnectionFactory = (DbConnectionFactory)Mockito.mock(DbConnectionFactory.class);
        Mockito.when((Object)dbConnectionFactory.createConnection(TransactionalAction.JOIN_IF_POSSIBLE)).thenReturn((Object)connection);
        SelectExecutor selectExecutor = (SelectExecutor)Mockito.mock(SelectExecutor.class);
        SelectMessageProcessor processor = new SelectMessageProcessor(null, null, null, null, false);
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage muleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)muleMessage);
        processor.process(event);
        ((SelectExecutor)Mockito.verify((Object)selectExecutor, (VerificationMode)Mockito.times((int)1))).execute((DbConnection)Matchers.eq((Object)connection), (Query)Matchers.any(Query.class));
        ((DbConnectionFactory)Mockito.verify((Object)dbConnectionFactory, (VerificationMode)Mockito.times((int)1))).releaseConnection(connection);
    }
}

