/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.database;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.registry.MuleRegistry;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.resolver.database.DefaultDbConfigResolver;
import org.mule.module.db.internal.resolver.database.UnresolvableDbConfigException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultDbConfigResolverTestCase
extends AbstractMuleTestCase {
    private final MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);

    @Test
    public void resolvesDefaultDbConfig() throws Exception {
        DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        MuleRegistry registry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        ArrayList<DbConfig> foundDbConfigs = new ArrayList<DbConfig>();
        foundDbConfigs.add(dbConfig);
        Mockito.when((Object)registry.lookupObjects(DbConfig.class)).thenReturn(foundDbConfigs);
        DefaultDbConfigResolver dbConfigResolver = new DefaultDbConfigResolver(registry);
        DbConfig resolvedDbConfig = dbConfigResolver.resolve(this.muleEvent);
        Assert.assertThat((Object)dbConfig, (Matcher)IsSame.sameInstance((Object)resolvedDbConfig));
    }

    @Test(expected=UnresolvableDbConfigException.class)
    public void throwsErrorWhenNoDbConfigAvailable() throws Exception {
        MuleRegistry registry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        ArrayList foundDbConfigs = new ArrayList();
        Mockito.when((Object)registry.lookupObjects(DbConfig.class)).thenReturn(foundDbConfigs);
        DefaultDbConfigResolver dbConfigResolver = new DefaultDbConfigResolver(registry);
        dbConfigResolver.resolve(this.muleEvent);
    }

    @Test
    public void throwsErrorWhenMultipleDbConfigAvailable() throws Exception {
        DbConfig dbConfig1 = (DbConfig)Mockito.mock(DbConfig.class);
        Mockito.when((Object)dbConfig1.getName()).thenReturn((Object)"dbConfig1");
        DbConfig dbConfig2 = (DbConfig)Mockito.mock(DbConfig.class);
        Mockito.when((Object)dbConfig2.getName()).thenReturn((Object)"dbConfig2");
        MuleRegistry registry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        ArrayList<DbConfig> foundDbConfigs = new ArrayList<DbConfig>();
        foundDbConfigs.add(dbConfig1);
        foundDbConfigs.add(dbConfig2);
        Mockito.when((Object)registry.lookupObjects(DbConfig.class)).thenReturn(foundDbConfigs);
        DefaultDbConfigResolver dbConfigResolver = new DefaultDbConfigResolver(registry);
        try {
            dbConfigResolver.resolve(this.muleEvent);
            Assert.fail((String)"Was supposed to fail when there are multiple dbConfigs available");
        }
        catch (UnresolvableDbConfigException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)JUnitMatchers.containsString((String)"dbConfig1"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)JUnitMatchers.containsString((String)"dbConfig2"));
        }
    }
}

