/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.test.util;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.DbConnection;

public class DbConnectionBuilder {
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);

    public DbConnectionBuilder onCalatog(String name) {
        try {
            Mockito.when((Object)this.connection.getCatalog()).thenReturn((Object)name);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this;
    }

    public DbConnectionBuilder with(DatabaseMetaData metaData) {
        try {
            Mockito.when((Object)this.connection.getMetaData()).thenReturn((Object)metaData);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this;
    }

    public DbConnectionBuilder preparing(String sqlText, PreparedStatement statement) {
        try {
            Mockito.when((Object)this.connection.prepareStatement(sqlText)).thenReturn((Object)statement);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this;
    }

    public DbConnection build() {
        return this.connection;
    }
}

