/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.BulkExecutor;
import org.mule.module.db.internal.domain.executor.BulkQueryExecutorFactory;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.AbstractDbMessageProcessor;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.param.DynamicParamValueResolver;
import org.mule.module.db.internal.resolver.query.QueryResolver;

public class PreparedBulkUpdateMessageProcessor
extends AbstractDbMessageProcessor {
    private final QueryResolver queryResolver;
    private final BulkQueryExecutorFactory bulkUpdateExecutorFactory;
    private final List<QueryType> validQueryTypes;
    private String source;
    private AutoGeneratedKeyStrategy autoGeneratedKeyStrategy;

    public PreparedBulkUpdateMessageProcessor(DbConfigResolver dbConfigResolver, QueryResolver queryResolver, BulkQueryExecutorFactory bulkUpdateExecutorFactory, TransactionalAction transactionalAction, List<QueryType> validQueryTypes) {
        super(dbConfigResolver, transactionalAction);
        this.queryResolver = queryResolver;
        this.bulkUpdateExecutorFactory = bulkUpdateExecutorFactory;
        this.validQueryTypes = validQueryTypes;
        this.autoGeneratedKeyStrategy = new NoAutoGeneratedKeyStrategy();
    }

    @Override
    protected Object executeQuery(DbConnection connection, MuleEvent muleEvent) throws SQLException {
        Query query = this.queryResolver.resolve(connection, muleEvent);
        this.validateQueryType(query.getQueryTemplate());
        List<List<QueryParamValue>> paramValues = this.resolveParamSets(muleEvent, query);
        BulkExecutor bulkUpdateExecutor = this.bulkUpdateExecutorFactory.create();
        return bulkUpdateExecutor.execute(connection, query, paramValues);
    }

    private List<List<QueryParamValue>> resolveParamSets(MuleEvent muleEvent, Query query) {
        Object payload = this.source == null || this.source.equals("") ? muleEvent.getMessage().getPayload() : this.muleContext.getExpressionManager().evaluate(this.source, muleEvent);
        Iterator<Object> paramsIterator = this.getIterator(payload);
        DynamicParamValueResolver paramValueResolver = new DynamicParamValueResolver(this.muleContext.getExpressionManager());
        LinkedList<List<QueryParamValue>> result = new LinkedList<List<QueryParamValue>>();
        while (paramsIterator.hasNext()) {
            DefaultMuleMessage itemMessage = new DefaultMuleMessage(paramsIterator.next(), this.muleContext);
            DefaultMuleEvent itemEvent = new DefaultMuleEvent((MuleMessage)itemMessage, muleEvent);
            List<QueryParamValue> queryParamValues = paramValueResolver.resolveParams((MuleEvent)itemEvent, query.getParamValues());
            result.add(queryParamValues);
        }
        return result;
    }

    private Iterator<Object> getIterator(Object payload) {
        if (payload instanceof Iterable) {
            return ((Iterable)payload).iterator();
        }
        if (payload instanceof Iterator) {
            return (Iterator)payload;
        }
        throw new IllegalArgumentException(String.format("Bulk mode operations require a Iterable/Iterator as payload. Got %s instead", payload != null ? payload.getClass().getCanonicalName() : "null"));
    }

    @Override
    protected List<QueryType> getValidQueryTypes() {
        return this.validQueryTypes;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    public void setAutoGeneratedKeyStrategy(AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) {
        this.autoGeneratedKeyStrategy = autoGeneratedKeyStrategy;
    }
}

