/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.delete;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Planet;

public class DeleteBulkTargetTestCase
extends AbstractDbIntegrationTestCase {
    public DeleteBulkTargetTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/delete/delete-bulk-target-config.xml"};
    }

    @Test
    public void usesCustomTarget() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        ArrayList<String> planetNames = new ArrayList<String>();
        planetNames.add(Planet.VENUS.getName());
        planetNames.add(Planet.MARS.getName());
        MuleMessage response = client.send("vm://deleteCustomTarget", planetNames, null);
        this.assertBulkDelete(response.getInboundProperty("updateCount"));
    }

    private void assertBulkDelete(Object payload) throws SQLException {
        Assert.assertTrue((boolean)(payload instanceof int[]));
        int[] counters = (int[])payload;
        Assert.assertEquals((long)2L, (long)counters.length);
        DbTestUtil.assertExpectedUpdateCount(1, counters[0]);
        DbTestUtil.assertExpectedUpdateCount(1, counters[1]);
        this.assertDeletedPlanetRecords("Pluto", "Venus");
    }
}

