/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.model;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.ContactDetails;
import org.mule.module.db.integration.model.RegionManager;
import org.mule.module.db.integration.model.derbyutil.DerbyTestStoredProcedure;

public class DerbyTestDatabase
extends AbstractTestDatabase {
    public static final String DERBY_ERROR_OBJECT_ALREADY_EXISTS = "X0Y68";
    public static String SQL_CREATE_SP_UPDATE_TEST_TYPE_1 = "CREATE PROCEDURE updateTestType1()\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nMODIFIES SQL DATA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME '" + DerbyTestStoredProcedure.class.getName() + ".updateTestType1'";
    public static String SQL_CREATE_SP_PARAM_UPDATE_TEST_TYPE_1 = "CREATE PROCEDURE updateParamTestType1(name VARCHAR(40))\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nMODIFIES SQL DATA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME '" + DerbyTestStoredProcedure.class.getName() + ".updateParameterizedTestType1'";
    public static String SQL_CREATE_SP_COUNT_RECORDS = "CREATE PROCEDURE countTestRecords(OUT COUNT INTEGER)\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nREADS SQL DATA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME '" + DerbyTestStoredProcedure.class.getName() + ".countTestRecords'";
    public static String SQL_CREATE_SP_GET_RECORDS = "CREATE PROCEDURE getTestRecords()\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nREADS SQL DATA\nDYNAMIC RESULT SETS 1\nEXTERNAL NAME '" + DerbyTestStoredProcedure.class.getName() + ".getTestRecords'";
    public static String SQL_CREATE_SP_GET_SPLIT_RECORDS = "CREATE PROCEDURE getSplitTestRecords()\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nREADS SQL DATA\nDYNAMIC RESULT SETS 2\nEXTERNAL NAME '" + DerbyTestStoredProcedure.class.getName() + ".getSplitTestRecords'";
    public static String SQL_CREATE_SP_DOUBLE_MY_INT = "CREATE PROCEDURE doubleMyInt(INOUT MYINT INTEGER)\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME '" + DerbyTestStoredProcedure.class.getName() + ".doubleMyInt'";
    public static String SQL_CREATE_SP_MULTIPLY_INTS = "CREATE PROCEDURE multiplyInts(IN INT1 INTEGER, IN INT2 INTEGER, OUT RESULT1 INTEGER, IN INT3 INTEGER, OUT RESULT2 INTEGER)\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME '" + DerbyTestStoredProcedure.class.getName() + ".multiplyInts'";
    public static String SQL_CREATE_SP_CONCATENATE_STRINGS = "CREATE PROCEDURE concatenateStrings(IN INT1 VARCHAR(100), IN INT2 VARCHAR(100), OUT RESULT VARCHAR(200))\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME '" + DerbyTestStoredProcedure.class.getName() + ".concatenateStrings'";
    public static final String SQL_CREATE_DELAY_FUNCTION = "create function delay(SECONDS INTEGER) returns INTEGER language java parameter style java external name '" + DerbyTestStoredProcedure.class.getName() + ".timeDelay'";
    public static final String SQL_CREATE_CONTACT_DETAIL_FUNCTION = "create function createContactDetails(DESCRIPTION VARCHAR(32), PHONE VARCHAR(32), EMAIL VARCHAR(32)) returns CONTACT_DETAILS language java parameter style java external name '" + DerbyTestStoredProcedure.class.getName() + ".createContactDetails'";
    public static final String SQL_CREATE_SP_GET_MANAGER_DETAILS = "CREATE PROCEDURE getManagerDetails(IN NAME VARCHAR(32), OUT RESULT CONTACT_DETAILS)\nPARAMETER STYLE JAVA\nLANGUAGE JAVA\nDYNAMIC RESULT SETS 0\nEXTERNAL NAME '" + DerbyTestStoredProcedure.class.getName() + ".getManagerDetails'";
    public static final String CREATE_CONTACT_DETAILS_TYPE = "CREATE TYPE CONTACT_DETAILS EXTERNAL NAME '" + ContactDetails.class.getName() + "' LANGUAGE JAVA";

    @Override
    public void createPlanetTable(Connection connection) throws SQLException {
        DerbyTestDatabase.executeDdl(connection, "CREATE TABLE PLANET(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0)  NOT NULL PRIMARY KEY,POSITION INTEGER,NAME VARCHAR(255))");
    }

    @Override
    protected String getInsertPlanetSql(String name, int position) {
        return "INSERT INTO PLANET(POSITION, NAME) VALUES (" + position + ", '" + name + "')";
    }

    @Override
    public void createStoredProcedureUpdateTestType1(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_UPDATE_TEST_TYPE_1);
    }

    @Override
    public void createStoredProcedureParameterizedUpdateTestType1(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_PARAM_UPDATE_TEST_TYPE_1);
    }

    @Override
    public void createStoredProcedureCountRecords(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_COUNT_RECORDS);
    }

    @Override
    public void createStoredProcedureGetRecords(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_GET_RECORDS);
    }

    @Override
    public void createStoredProcedureGetSplitRecords(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_GET_SPLIT_RECORDS);
    }

    @Override
    public void createStoredProcedureDoubleMyInt(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_DOUBLE_MY_INT);
    }

    @Override
    protected boolean supportsSimpleUdt() {
        return true;
    }

    @Override
    public void createStoredProcedureGetManagerDetails(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_GET_MANAGER_DETAILS);
    }

    @Override
    protected void createContactDetailsType(Connection connection) throws SQLException {
        block2: {
            try {
                String ddl = CREATE_CONTACT_DETAILS_TYPE;
                DerbyTestDatabase.executeDdl(connection, ddl);
            }
            catch (SQLException e) {
                if (DERBY_ERROR_OBJECT_ALREADY_EXISTS.equals(e.getSQLState())) break block2;
                throw e;
            }
        }
    }

    @Override
    protected void deleteRegionManagersTable(Connection connection) throws SQLException {
        this.executeUpdate(connection, "DELETE FROM REGION_MANAGERS");
    }

    @Override
    protected void createRegionManagersTable(Connection connection) throws SQLException {
        String ddl = "CREATE TABLE REGION_MANAGERS(REGION_NAME VARCHAR(32) NOT NULL PRIMARY KEY,MANAGER_NAME VARCHAR(32) NOT NULL,DETAILS CONTACT_DETAILS NOT NULL)";
        DerbyTestDatabase.executeDdl(connection, ddl);
        DerbyTestDatabase.executeDdl(connection, SQL_CREATE_CONTACT_DETAIL_FUNCTION);
    }

    @Override
    protected String getInsertRegionManagerSql(RegionManager regionManager) {
        StringBuilder builder = new StringBuilder("INSERT INTO REGION_MANAGERS VALUES ('").append(regionManager.getRegionName()).append("', '").append(regionManager.getName()).append("', createContactDetails('").append(regionManager.getContactDetails().getDescription()).append("', '").append(regionManager.getContactDetails().getPhoneNumber()).append("', '").append(regionManager.getContactDetails().getEmail()).append("'))");
        return builder.toString();
    }

    @Override
    public void createStoredProcedureMultiplyInts(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_MULTIPLY_INTS);
    }

    @Override
    public void createStoredProcedureConcatenateStrings(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_SP_CONCATENATE_STRINGS);
    }

    @Override
    public void createDelayFunction(DataSource dataSource) throws SQLException {
        this.createStoredProcedure(dataSource, SQL_CREATE_DELAY_FUNCTION);
    }

    @Override
    public void createStoredProcedure(DataSource dataSource, String sql) throws SQLException {
        block2: {
            try {
                super.createStoredProcedure(dataSource, sql);
            }
            catch (SQLException e) {
                if (DERBY_ERROR_OBJECT_ALREADY_EXISTS.equals(e.getSQLState())) break block2;
                throw e;
            }
        }
    }
}

